/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.local;

import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import com.aliyun.odps.mapred.local.JobCounter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class LocalGroupingRecordIterator
implements Iterator<Record> {
    private WritableRecord key;
    private WritableRecord value;
    private Object[] prefetch;
    private boolean hasNext;
    private Comparator<Object[]> keyGroupingComparator;
    private Queue<Object[]> queue;
    private boolean incInputRecordCount;
    private Counters counters;

    public LocalGroupingRecordIterator(Queue<Object[]> queue, WritableRecord key, WritableRecord value, Comparator<Object[]> keyGroupingComparator, boolean incInputRecordCount, Counters counters) {
        this.queue = queue;
        this.key = key;
        this.value = value;
        this.keyGroupingComparator = keyGroupingComparator;
        this.incInputRecordCount = incInputRecordCount;
        this.counters = counters;
    }

    private void fillKeyValue(Object[] objs) {
        this.key.set(Arrays.copyOf(objs, this.key.getColumnCount()));
        this.value.set(Arrays.copyOfRange(objs, this.key.getColumnCount(), this.key.getColumnCount() + this.value.getColumnCount()));
        if (this.incInputRecordCount) {
            this.counters.findCounter((Enum)JobCounter.__EMPTY_INPUT_RECORD_COUNT).increment(1L);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.prefetch != null) {
            return this.hasNext;
        }
        this.prefetch = this.queue.poll();
        if (this.prefetch == null || this.keyGroupingComparator.compare(this.key.toWritableArray(), this.prefetch) != 0) {
            this.hasNext = false;
        } else {
            this.hasNext = true;
            this.fillKeyValue(this.prefetch);
        }
        return this.hasNext;
    }

    public boolean reset() {
        if (this.prefetch != null) {
            this.hasNext = true;
            this.fillKeyValue(this.prefetch);
            return true;
        }
        return false;
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.prefetch = null;
        return this.value;
    }

    @Override
    public void remove() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.prefetch = null;
    }
}

