/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ml.OfflineModel;
import com.aliyun.odps.ml.OfflineModelFilter;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ShowOfflineModelsCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"show", "offline", "model", "offlinemodels", "offlinemodel"};
    private String projectName = null;
    private String modelNamePrefix = null;
    private static final Pattern PATTERN = Pattern.compile("\\s*(SHOW||LIST)\\s+OFFLINEMODELS($|\\s+(.*))", 34);

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: show offlinemodels [-p,-project <project_name>] [offlinemodel_name_prefix]");
    }

    public ShowOfflineModelsCommand(String projectName, String modelNamePrefix, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.projectName = projectName;
        this.modelNamePrefix = modelNamePrefix;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        OfflineModelFilter filter = null;
        if (this.modelNamePrefix != null) {
            filter = new OfflineModelFilter();
            filter.setName(this.modelNamePrefix);
        }
        long size = 0L;
        Iterator models = odps.offlineModels().iterator(this.projectName, filter);
        while (models.hasNext()) {
            ODPSConsoleUtils.checkThreadInterrupted();
            OfflineModel model = (OfflineModel)models.next();
            this.getWriter().writeResult(model.getName());
            ++size;
        }
        this.getWriter().writeResult("\n" + size + " offlinemodels");
        System.out.flush();
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("p", "project", true, "user spec project");
        return options;
    }

    private static CommandLine getCommandLine(String[] args) throws ODPSConsoleException {
        try {
            GnuParser parser = new GnuParser();
            return parser.parse(ShowOfflineModelsCommand.getOptions(), args);
        }
        catch (ParseException e) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  " + e.getMessage(), (Throwable)e);
        }
    }

    public static ShowOfflineModelsCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        if (cmd == null || ctx == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(cmd);
        if (!matcher.matches()) {
            return null;
        }
        String input = matcher.group(2);
        String[] inputs = new AntlrObject(input).getTokenStringArray();
        CommandLine commandLine = ShowOfflineModelsCommand.getCommandLine(inputs);
        String projectName = null;
        if (commandLine.hasOption("p")) {
            projectName = commandLine.getOptionValue("p");
        }
        if (commandLine.getArgList().size() > 1) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Invalid command.");
        }
        String modelNamePrefix = null;
        if (commandLine.getArgList().size() == 1 && !(modelNamePrefix = commandLine.getArgs()[0]).matches("[.\\w]+")) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Invalid model prefix.");
        }
        if (projectName == null) {
            projectName = ctx.getProjectName();
        }
        ShowOfflineModelsCommand command = new ShowOfflineModelsCommand(projectName, modelNamePrefix, cmd, ctx);
        return command;
    }
}

