/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class AlinkAdapterContext {
    @SerializedName(value="DefaultFlinkVersion")
    private String defaultFlinkVersion;
    @SerializedName(value="DefaultAlinkMajorVersion")
    private String defaultAlinkMajorVersion;
    @SerializedName(value="DefaultAlinkMinorVersion")
    private String defaultAlinkMinorVersion;
    @SerializedName(value="DefaultFlinkResource")
    private String defaultFlinkResource;
    @SerializedName(value="DefaultAlinkBaseResource")
    private String defaultAlinkBaseResource;
    @SerializedName(value="DefaultAlinkAlgoResource")
    private String defaultAlinkAlgoResource;
    @SerializedName(value="TransformConfig")
    private List<TransformAlgorithmsConfig> transformAlgorithmsConfig = new ArrayList<TransformAlgorithmsConfig>();

    public String getDefaultFlinkVersion() {
        return this.defaultFlinkVersion;
    }

    public String getDefaultAlinkMajorVersion() {
        return this.defaultAlinkMajorVersion;
    }

    public String getDefaultAlinkMinorVersion() {
        return this.defaultAlinkMinorVersion;
    }

    public String getDefaultFlinkResource() {
        return this.defaultFlinkResource;
    }

    public String getDefaultAlinkBaseResource() {
        return this.defaultAlinkBaseResource;
    }

    public String getDefaultAlinkAlgoResource() {
        return this.defaultAlinkAlgoResource;
    }

    public List<TransformAlgorithmsConfig> getTransformAlgorithmsConfig() {
        return this.transformAlgorithmsConfig;
    }

    public TransformAlgorithmsConfig getTransAlgorithmsConfig(String algoName) {
        for (TransformAlgorithmsConfig config : this.transformAlgorithmsConfig) {
            if (!config.xflowAlgoName.toUpperCase().equals(algoName.toUpperCase())) continue;
            return config;
        }
        return null;
    }

    public static AlinkAdapterContext load(ExecutionContext paiContext, Odps odps, String project, String contextResourceName) throws OdpsException, IOException {
        AlinkAdapterContext context = null;
        try {
            InputStream jsonStream = odps.resources().getResourceAsStream(project, contextResourceName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(jsonStream));
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            context = (AlinkAdapterContext)gson.fromJson((Reader)reader, AlinkAdapterContext.class);
        }
        catch (Exception e) {
            paiContext.getOutputWriter().writeDebug("Load alink adapter context failed:" + e.getMessage());
        }
        return context;
    }

    public class TransformAlgorithmsConfig {
        @SerializedName(value="XflowAlgoName")
        private String xflowAlgoName;
        @SerializedName(value="ProjectList")
        private List<String> projectList = new ArrayList<String>();

        public String getXflowAlgoName() {
            return this.xflowAlgoName;
        }

        public List<String> getProjectList() {
            return this.projectList;
        }
    }
}

