/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.XFlows;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.CommandExecutor;
import com.aliyun.openservices.odps.console.utils.FileUtil;
import com.aliyun.openservices.odps.console.utils.PluginUtil;
import com.aliyun.openservices.odps.console.xflow.AlinkAdapterContext;
import com.aliyun.openservices.odps.console.xflow.AlinkTransformer;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class AlinkAdapter {
    private static final String TEMP_RESOURCE_PREFIX = "file:";
    private static final String ALGO_PUBLIC_PROJECT = "algo_public";
    private static final String ALINK_ADAPTER_CONTEXT_RES_NAME = "alink_adapter_context.json";
    private static final String ALINK_VERSION_OPT = "alink_version";
    private static final String FLINK_VERSION_PLACEHOLDER = "${FlinkVersion}";
    private static final String ALINK_MAJOR_VERSION_PLACEHOLDER = "${AlinkMajorVersion}";
    private static final String ALINK_MINOR_VERSION_PLACEHOLDER = "${AlinkMinorVersion}";
    private static final String ODPS_SCHEME = "odps://";
    private static final String ODPS_CONSOLE_ROOT_DIR = PluginUtil.getRootPath();
    private static final String FLINK_CONSOLE_RPM_DIR = "/opt/taobao/tbdpapp/pai_alink_flink_console/";
    private static final String ALINK_BASE_RPM_DIR = "/opt/taobao/tbdpapp/pai_alink_base/";
    private static final String FLINK_CONSOLE_LOCAL_DIR = ODPS_CONSOLE_ROOT_DIR + "/.alink_root/flink_console/";
    private static final String ALINK_BASE_LOCAL_DIR = ODPS_CONSOLE_ROOT_DIR + "/.alink_root/alink_base/";
    private static final String ALINK_ALGO_LOCAL_DIR = ODPS_CONSOLE_ROOT_DIR + "/.alink_root/alink_algo/";
    private ExecutionContext paiContext;
    private Odps odps;
    private CommandLine commandLine;
    private String algoProject;
    private AlinkAdapterContext context;
    private AlinkAdapterContext.TransformAlgorithmsConfig transformConfig;
    private String flinkVersion;
    private String alinkMajorVersion;
    private String alinkMinorVersion;
    public static final Pattern cupidPattern = Pattern.compile("CUPID_TASK_PLAN_INFO:(?<plan>[^\n]+?)\n", 34);

    public AlinkAdapter(ExecutionContext paiContext, Odps odps, CommandLine commandLine) throws ODPSConsoleException {
        this.paiContext = paiContext;
        this.odps = odps;
        this.commandLine = commandLine;
        this.algoProject = commandLine.hasOption("project") ? commandLine.getOptionValue("project") : ALGO_PUBLIC_PROJECT;
        try {
            this.context = AlinkAdapterContext.load(paiContext, odps, this.algoProject, ALINK_ADAPTER_CONTEXT_RES_NAME);
        }
        catch (OdpsException odpsException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.context == null || this.context.getTransformAlgorithmsConfig().isEmpty()) {
            this.transformConfig = null;
            paiContext.getOutputWriter().writeDebug("TransformConfig is empty.");
            return;
        }
        String xflowName = commandLine.getOptionValue("name");
        this.transformConfig = this.context.getTransAlgorithmsConfig(xflowName);
        if (this.transformConfig == null) {
            paiContext.getOutputWriter().writeDebug("No need to transform " + xflowName + " to alink xflow.");
            return;
        }
        this.flinkVersion = this.context.getDefaultFlinkVersion();
        this.alinkMajorVersion = this.context.getDefaultAlinkMajorVersion();
        this.alinkMinorVersion = this.context.getDefaultAlinkMinorVersion();
        if (commandLine.hasOption(ALINK_VERSION_OPT)) {
            String alinkVersion = commandLine.getOptionValue(ALINK_VERSION_OPT);
            String[] versions = alinkVersion.split("-");
            if (versions.length != 3) {
                String errMsg = "Invalid alink version:" + alinkVersion + ", the format should be like `1.9.0-v1.0-v1.0`.";
                paiContext.getOutputWriter().writeError(errMsg);
                throw new ODPSConsoleException(errMsg);
            }
            paiContext.getOutputWriter().writeDebug("Specified alink version:" + alinkVersion);
            this.flinkVersion = versions[0].trim();
            this.alinkMajorVersion = versions[1].trim();
            this.alinkMinorVersion = versions[2].trim();
        }
    }

    public static void uncompressTarGZ(File tarFile, File dest) throws IOException {
        TarArchiveInputStream tarIn = null;
        tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(tarFile))));
        TarArchiveEntry tarEntry = tarIn.getNextTarEntry();
        while (tarEntry != null) {
            File destPath = new File(dest, tarEntry.getName());
            if (tarEntry.isDirectory()) {
                destPath.mkdirs();
            } else {
                destPath.createNewFile();
                byte[] btoRead = new byte[1024];
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(destPath));
                int len = 0;
                while ((len = tarIn.read(btoRead)) != -1) {
                    bout.write(btoRead, 0, len);
                }
                bout.close();
                btoRead = null;
            }
            tarEntry = tarIn.getNextTarEntry();
        }
        tarIn.close();
    }

    public String getOrDownloadOdpsResource(String resourcePath, String localDir) throws ODPSConsoleException, OdpsException {
        return this.getOrDownloadOdpsResource(resourcePath, localDir, false);
    }

    public String getOrDownloadOdpsResource(String resourcePath, String localDir, boolean needUncompress) throws ODPSConsoleException, OdpsException {
        String resPath = resourcePath.replaceFirst(ODPS_SCHEME, "");
        String project = resPath.substring(0, resPath.indexOf(47));
        String resName = resPath.substring(resPath.lastIndexOf(47) + 1);
        String resLocalPath = localDir + "/" + resName;
        if (AlinkAdapter.pathExists(resLocalPath)) {
            this.getLogWriter().writeDebug("Resource " + resLocalPath + " already exists, no need to download.");
            return resLocalPath;
        }
        this.getLogWriter().writeDebug("Download odps resource " + resourcePath + " to " + resLocalPath + ", project:" + project + ", resourceName:" + resName + ".");
        File localDirEntry = new File(localDir);
        localDirEntry.mkdirs();
        InputStream resStream = this.odps.resources().getResourceAsStream(project, resName);
        try {
            FileUtil.saveInputStreamToFile((InputStream)resStream, (String)resLocalPath);
        }
        catch (Exception e) {
            throw new OdpsException(e);
        }
        if (needUncompress) {
            File flinkTarGzFile = new File(resLocalPath);
            File outputDir = new File(localDir);
            try {
                this.getLogWriter().writeDebug("Uncompress " + flinkTarGzFile + " to " + outputDir);
                AlinkAdapter.uncompressTarGZ(flinkTarGzFile, outputDir);
            }
            catch (Exception e) {
                throw new ODPSConsoleException((Throwable)e);
            }
        }
        return resLocalPath;
    }

    public boolean needTransform() {
        if (this.transformConfig == null) {
            return false;
        }
        String runningProject = this.odps.getDefaultProject();
        return this.transformConfig.getProjectList() == null || this.transformConfig.getProjectList().isEmpty() || this.transformConfig.getProjectList().contains(runningProject);
    }

    public XFlows.XFlowInstance createXflowInstance(AlinkTransformer.AlgoJob algoJob, String cupidTaskPlanContent, String userSettings) throws ODPSConsoleException, OdpsException {
        XFlows.XFlowInstance xFlowInstance = new XFlows.XFlowInstance();
        xFlowInstance.setXflowName(algoJob.algoName);
        xFlowInstance.setProject(this.algoProject);
        String guid = UUID.randomUUID().toString();
        xFlowInstance.setGuid(guid);
        Integer priority = this.paiContext.getPaiPriority();
        xFlowInstance.setPriority(priority.intValue());
        for (Map.Entry<String, String> property : algoJob.params.entrySet()) {
            String value = property.getValue().toString();
            if (value.toLowerCase().startsWith(TEMP_RESOURCE_PREFIX)) {
                try {
                    value = new URL(URLDecoder.decode(value, "utf-8")).getPath();
                }
                catch (IOException e) {
                    throw new ODPSConsoleException("Invalid temp fileName:" + e.getMessage(), (Throwable)e);
                }
                value = this.odps.resources().createTempResource(this.odps.getDefaultProject(), value).getName();
            }
            xFlowInstance.setParameter(property.getKey().toString(), value);
        }
        xFlowInstance.setParameter("cupidTaskPlan", cupidTaskPlanContent);
        if (!userSettings.isEmpty()) {
            xFlowInstance.setParameter("userSettings", userSettings);
        }
        HashMap<String, String> userConfig = AlinkAdapter.getUserConfig(this.commandLine);
        for (Map.Entry<String, String> property : userConfig.entrySet()) {
            xFlowInstance.setProperty(property.getKey(), property.getValue());
        }
        return xFlowInstance;
    }

    private DefaultOutputWriter getLogWriter() {
        return this.paiContext.getOutputWriter();
    }

    public String createTempCommandFile(String command) throws ODPSConsoleException {
        try {
            File tempCommandFile = File.createTempFile("alink_command_", ".sh");
            tempCommandFile.deleteOnExit();
            FileOutputStream outputStream = new FileOutputStream(tempCommandFile);
            outputStream.write(command.getBytes());
            outputStream.close();
            return tempCommandFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new ODPSConsoleException((Throwable)e);
        }
    }

    private String ExecuteShell(String command) throws ODPSConsoleException {
        try {
            CommandExecutor.ExecutorResult result = CommandExecutor.run((String)command, (boolean)false);
            if (result.getEcode() != 0) {
                throw new ODPSConsoleException("Executor command, error code:" + result.getEcode() + ", error:" + result.getErrorStr());
            }
            return result.getOutStr();
        }
        catch (IOException e) {
            throw new ODPSConsoleException((Throwable)e);
        }
    }

    public void writeFlinkConfFiles(AlinkTransformer.FlinkJob flinkJob, Map<String, String> defaultConfFiles, String localConfDir) throws ODPSConsoleException {
        try {
            File tmpConfDir = new File(localConfDir);
            if (!tmpConfDir.exists()) {
                tmpConfDir.mkdirs();
            }
            tmpConfDir.deleteOnExit();
            HashMap<String, String> allConfFiles = new HashMap<String, String>();
            if (flinkJob.confFiles != null) {
                allConfFiles.putAll(flinkJob.confFiles);
            }
            if (defaultConfFiles != null) {
                allConfFiles.putAll(defaultConfFiles);
            }
            if (allConfFiles.isEmpty()) {
                this.getLogWriter().writeDebug("No flink conf files to write");
                return;
            }
            for (Map.Entry entry : allConfFiles.entrySet()) {
                String confFilePath = localConfDir + (String)entry.getKey();
                this.getLogWriter().writeDebug("Write flink conf file:" + confFilePath);
                File confFile = new File(confFilePath);
                if (!confFile.createNewFile()) continue;
                confFile.deleteOnExit();
                FileOutputStream outputStream = new FileOutputStream(confFile);
                outputStream.write(((String)entry.getValue()).getBytes());
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new ODPSConsoleException((Throwable)e);
        }
    }

    public String generateCupidTaskPlanContent(AlinkTransformer.FlinkJobList flinkJobList, String alinkBaseJarFilePath, String alinkBaseJarDir, String alinkAlgoJarFilePath, String flinkConsoleLocalDir) throws ODPSConsoleException, OdpsException {
        String flinkLogPath = FLINK_CONSOLE_LOCAL_DIR + "log/";
        File flinkLogDir = new File(flinkLogPath);
        if (!flinkLogDir.exists()) {
            flinkLogDir.mkdirs();
        }
        String cupidTaskPlanContent = "";
        for (AlinkTransformer.FlinkJob job : flinkJobList.flinkJobs) {
            String tmpFlinkConfDir = FLINK_CONSOLE_LOCAL_DIR + UUID.randomUUID().toString() + "/";
            this.writeFlinkConfFiles(job, flinkJobList.defaultConfFiles, tmpFlinkConfDir);
            StringBuilder cmdBuilder = new StringBuilder();
            cmdBuilder.append("cd " + flinkConsoleLocalDir + " && ");
            HashMap<String, String> allEnvs = new HashMap<String, String>();
            this.getLogWriter().writeDebug("JAVA_HOME = " + System.getenv("JAVA_HOME"));
            allEnvs.put("JAVA_HOME", System.getenv("JAVA_HOME"));
            allEnvs.put("FLINK_LOG_DIR", flinkLogPath);
            allEnvs.put("FLINK_CONF_DIR", tmpFlinkConfDir);
            allEnvs.put("HADOOP_CLASSPATH", alinkBaseJarFilePath + ":" + tmpFlinkConfDir);
            allEnvs.put("CUPID_DRY_RUN_MODE_ENABLE", "true");
            if (job.envs != null) {
                allEnvs.putAll(job.envs);
            }
            for (Map.Entry env : allEnvs.entrySet()) {
                cmdBuilder.append((String)env.getKey() + "=" + (String)env.getValue() + " ");
            }
            cmdBuilder.append("./bin/flink run ");
            cmdBuilder.append("-yt " + alinkBaseJarDir + " ");
            for (String param : job.cupidParams) {
                cmdBuilder.append(param + " ");
            }
            cmdBuilder.append("-d " + alinkAlgoJarFilePath + " ");
            for (String param : job.alinkParams) {
                cmdBuilder.append(param + " ");
            }
            this.getLogWriter().writeError("Flink console is running...");
            this.getLogWriter().writeDebug("Flink command:" + cmdBuilder.toString());
            String cmdFile = this.createTempCommandFile(cmdBuilder.toString());
            String result = this.ExecuteShell("/bin/bash " + cmdFile);
            Matcher m = cupidPattern.matcher(result);
            if (m.find()) {
                cupidTaskPlanContent = cupidTaskPlanContent + m.group("plan");
                cupidTaskPlanContent = cupidTaskPlanContent + ";";
            }
            this.getLogWriter().writeError("Flink console execute success.");
        }
        if (!cupidTaskPlanContent.isEmpty()) {
            cupidTaskPlanContent = cupidTaskPlanContent.substring(0, cupidTaskPlanContent.length() - 1);
        }
        this.getLogWriter().writeDebug("cupidTaskPlanContent:" + cupidTaskPlanContent);
        return cupidTaskPlanContent;
    }

    public static HashMap<String, String> getUserConfig(CommandLine cl) {
        HashMap<String, String> userConfig = new HashMap<String, String>();
        String jobName = cl.getOptionValue("jobname");
        HashMap<String, String> settings = new HashMap<String, String>(SetCommand.setMap);
        if (jobName != null) {
            settings.put("odps.task.workflow.custom_job_name", jobName);
        }
        if (!settings.isEmpty()) {
            userConfig.put("settings", new GsonBuilder().disableHtmlEscaping().create().toJson(settings));
        }
        return userConfig;
    }

    public String generateCupidTaskSettings(AlinkTransformer.FlinkJob[] flinkJobs) {
        String settings = "";
        for (AlinkTransformer.FlinkJob job : flinkJobs) {
            String setting = "";
            for (Map.Entry<String, String> entry : job.confFiles.entrySet()) {
                String[] confKvs;
                String confContents = entry.getValue();
                for (String kv : confKvs = confContents.split("\n")) {
                    if (!kv.startsWith("odps.") || kv.startsWith("odps.access.")) continue;
                    setting = kv.contains(": ") ? setting + kv.replaceFirst(": ", "=") + "," : setting + kv + ",";
                }
            }
            if (!setting.isEmpty()) {
                setting = setting.substring(0, setting.length() - 1);
            }
            settings = settings + setting + ";";
        }
        if (!settings.isEmpty()) {
            settings = settings.substring(0, settings.length() - 1);
        }
        return settings;
    }

    private static boolean pathExists(String filePath) {
        return new File(filePath).exists();
    }

    private static String getAbsolutePath(String relativePath) {
        return new File(relativePath).getAbsolutePath();
    }

    private String getFlinkConsoleRootDir() throws ODPSConsoleException, OdpsException {
        String flinkConsoleRootDirName = "flink-" + this.flinkVersion + "-odps/";
        String flinkConsoleRpmPath = FLINK_CONSOLE_RPM_DIR + flinkConsoleRootDirName;
        if (AlinkAdapter.pathExists(flinkConsoleRpmPath)) {
            this.getLogWriter().writeDebug("Find flink console " + flinkConsoleRpmPath + " in rpm dir.");
            return flinkConsoleRpmPath;
        }
        this.getLogWriter().writeDebug("Flink console " + flinkConsoleRpmPath + " not found in rpm dir, download from odps resource.");
        String flinkConsoleResPath = this.context.getDefaultFlinkResource().replace(FLINK_VERSION_PLACEHOLDER, this.flinkVersion);
        String flinkConsoleLocalDir = AlinkAdapter.getAbsolutePath(FLINK_CONSOLE_LOCAL_DIR + this.flinkVersion);
        this.getOrDownloadOdpsResource(flinkConsoleResPath, flinkConsoleLocalDir, true);
        String flinkConsoleRootDir = flinkConsoleLocalDir + File.separator + flinkConsoleRootDirName;
        if (!AlinkAdapter.pathExists(flinkConsoleRootDir)) {
            throw new ODPSConsoleException("Flink console " + flinkConsoleRootDir + " not found.");
        }
        this.getLogWriter().writeDebug("Flink console root dir: " + flinkConsoleRootDir + ".");
        String chmodCmd = "chmod +x " + flinkConsoleRootDir + "/bin/flink";
        this.ExecuteShell(chmodCmd);
        return flinkConsoleRootDir;
    }

    private String getAlinkBaseJarFilePath() throws ODPSConsoleException, OdpsException {
        String alinkBaseJarRpmPath = "/opt/taobao/tbdpapp/pai_alink_base/alink-base-" + this.alinkMajorVersion + ".jar";
        if (AlinkAdapter.pathExists(alinkBaseJarRpmPath)) {
            this.getLogWriter().writeDebug("Find alink base jar " + alinkBaseJarRpmPath + " in rpm dir.");
            return alinkBaseJarRpmPath;
        }
        this.getLogWriter().writeDebug("Alink base jar " + alinkBaseJarRpmPath + " not found in rpm dir, download from odps resource.");
        String alinkBaseResPath = this.context.getDefaultAlinkBaseResource().replace(ALINK_MAJOR_VERSION_PLACEHOLDER, this.alinkMajorVersion);
        String alinkBaseLocalDir = AlinkAdapter.getAbsolutePath(ALINK_BASE_LOCAL_DIR + this.alinkMajorVersion);
        return this.getOrDownloadOdpsResource(alinkBaseResPath, alinkBaseLocalDir);
    }

    private String getAlinkAlgoJarFilePath() throws ODPSConsoleException, OdpsException {
        String alinkAlgoResPath = this.context.getDefaultAlinkAlgoResource().replace(FLINK_VERSION_PLACEHOLDER, this.flinkVersion).replace(ALINK_MAJOR_VERSION_PLACEHOLDER, this.alinkMajorVersion).replace(ALINK_MINOR_VERSION_PLACEHOLDER, this.alinkMinorVersion);
        String alinkAlgoLocalDir = AlinkAdapter.getAbsolutePath(ALINK_ALGO_LOCAL_DIR + this.flinkVersion + "-" + this.alinkMajorVersion + "-" + this.alinkMinorVersion);
        return this.getOrDownloadOdpsResource(alinkAlgoResPath, alinkAlgoLocalDir);
    }

    public XFlows.XFlowInstance createAlinkXflowInstance() throws ODPSConsoleException, OdpsException {
        if (!this.needTransform()) {
            return null;
        }
        String flinkConsoleRootDir = this.getFlinkConsoleRootDir();
        String alinkBaseJarFilePath = this.getAlinkBaseJarFilePath();
        String alinkBaseLocalDir = alinkBaseJarFilePath.substring(0, alinkBaseJarFilePath.lastIndexOf(47));
        String alinkAlgoJarFilePath = this.getAlinkAlgoJarFilePath();
        AlinkTransformer alinkTransformer = new AlinkTransformer();
        try {
            alinkTransformer.generateFlinkJobs(this.paiContext, this.commandLine, flinkConsoleRootDir, alinkBaseJarFilePath, alinkAlgoJarFilePath);
        }
        catch (Exception e) {
            throw new ODPSConsoleException((Throwable)e);
        }
        AlinkTransformer.FlinkJobList flinkJobList = alinkTransformer.getFlinkJobList();
        String cupidPlanContent = this.generateCupidTaskPlanContent(flinkJobList, alinkBaseJarFilePath, alinkBaseLocalDir, alinkAlgoJarFilePath, flinkConsoleRootDir);
        String userSettings = this.generateCupidTaskSettings(flinkJobList.flinkJobs);
        return this.createXflowInstance(flinkJobList.xflowJob, cupidPlanContent, userSettings);
    }
}

