/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils.tune;

import com.aliyun.openservices.odps.console.utils.tune.ResourceCost;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TuningRecord {
    public int planNumber;
    public String candidatePlan;
    public Map<String, String> hints;
    public String estimatedCost;
    public boolean isCurrentSetting;
    public boolean isExplainTune;
    public String taskName;
    public String instanceId;
    public String result;
    public String logviewUrl;
    public String taskDetailJson;
    public long beginTimestamp;
    public long endTimestamp;
    public ResourceCost resourceCost;

    public TuningRecord(int planNumber, String candidatePlan, Map<String, String> hints, String estimatedCost, boolean isCurrentSetting, boolean isExplainTune) {
        this.planNumber = planNumber;
        this.candidatePlan = candidatePlan;
        this.hints = hints;
        this.estimatedCost = estimatedCost;
        this.isCurrentSetting = isCurrentSetting;
        this.isExplainTune = isExplainTune;
    }

    public long getLatency() {
        long latency = this.endTimestamp - this.beginTimestamp;
        if (latency <= 0L) {
            return -1L;
        }
        return latency;
    }

    String hintToSetting() {
        StringBuilder setting = new StringBuilder();
        this.hints.forEach((k, v) -> setting.append("set " + k + "=" + v + ";\n"));
        return " {\n" + setting + "}\n";
    }

    public static TuningRecord of(String candidatePlanDesc) {
        Pattern pattern = Pattern.compile("(\\d+)\\s+EstimatedCost: (.*?), IsCurrentSetting: (true|false)\\s+TuningHints: \\{(.*?)\\}\\s*Plan: (.+?)(?=-----|$)", 34);
        Matcher matcher = pattern.matcher(candidatePlanDesc);
        if (matcher.find()) {
            int planNumber = Integer.parseInt(matcher.group(1));
            String estimatedCost = matcher.group(2);
            boolean isCurrentSetting = Boolean.parseBoolean(matcher.group(3));
            String hintsString = matcher.group(4);
            String plan = matcher.group(5).trim();
            HashMap<String, String> hints = new HashMap<String, String>();
            Pattern hintPattern = Pattern.compile("set (\\w+(?:\\.\\w+)*?)=(.*?);");
            Matcher hintMatcher = hintPattern.matcher(hintsString);
            while (hintMatcher.find()) {
                hints.put(hintMatcher.group(1), hintMatcher.group(2));
            }
            return new TuningRecord(planNumber, plan, hints, estimatedCost, isCurrentSetting, false);
        }
        return null;
    }
}

