/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils.tune;

import com.aliyun.openservices.odps.console.utils.tune.ResourceCost;
import com.aliyun.openservices.odps.console.utils.tune.TuningRecord;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class TuningHistory {
    public List<TuningRecord> records;
    public String tuningSql;
    public int maxSqlPreviewLines = 50;
    public int maxSqlPreviewLength = 1000;

    public static TuningHistory of(String explainTuneDesc, String tuningSql) {
        TuningHistory tuningHistory = new TuningHistory();
        tuningHistory.records = new ArrayList<TuningRecord>();
        tuningHistory.tuningSql = tuningSql;
        if (explainTuneDesc == null) {
            return tuningHistory;
        }
        String[] planSections = explainTuneDesc.split("Candidate Plan #");
        for (int i = 1; i < planSections.length; ++i) {
            String candidatePlanDesc = planSections[i];
            TuningRecord record = TuningRecord.of(candidatePlanDesc);
            if (record == null) continue;
            tuningHistory.records.add(record);
        }
        return tuningHistory;
    }

    public String toTuningReport(boolean reportForHuman, boolean onlyShowBetterPlan) {
        List<TuningRecord> reportRecords = this.records.stream().sorted((l, r) -> {
            int ret;
            long lt = l.getLatency();
            long rt = r.getLatency();
            if (lt < 0L) {
                lt = Long.MAX_VALUE;
            }
            if (rt < 0L) {
                rt = Long.MAX_VALUE;
            }
            if ((ret = Long.compare(lt, rt)) != 0) {
                return ret;
            }
            return -Boolean.compare(l.isCurrentSetting, r.isCurrentSetting);
        }).collect(Collectors.toList());
        long bestLatency = ((TuningRecord)reportRecords.get(0)).getLatency();
        int reportSize = reportRecords.size();
        double currentCpuCost = -1.0;
        long currentLatency = -1L;
        for (TuningRecord record2 : reportRecords) {
            if (record2.resourceCost == null) {
                record2.resourceCost = ResourceCost.makeUnknownCost("Unknown");
            }
            if (!record2.isCurrentSetting) continue;
            currentCpuCost = record2.resourceCost.getCpuValue();
            currentLatency = record2.getLatency();
        }
        if (reportForHuman && onlyShowBetterPlan) {
            double finalCurrentCpuCost = currentCpuCost;
            long finalCurrentLatency = currentLatency;
            reportRecords = reportRecords.stream().filter(record -> {
                if (finalCurrentCpuCost < 0.0 || finalCurrentLatency < 0L || record.getLatency() < 0L || record.resourceCost.getCpuValue() < 0.0) {
                    return true;
                }
                return record.getLatency() <= finalCurrentLatency || !(record.resourceCost.getCpuValue() > finalCurrentCpuCost);
            }).collect(Collectors.toList());
        }
        int planNotDisplayed = reportSize - reportRecords.size();
        return this.makeReport(reportRecords, bestLatency, reportForHuman, planNotDisplayed);
    }

    private String makeReport(List<TuningRecord> sortedRecords, long bestLatency, boolean reportForHuman, int planNotDisplayed) {
        StringBuilder report = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        report.append("TUNING REPORT:\n");
        report.append("-----------------------------------------\n");
        String[] sqlLines = this.tuningSql.split("\\r?\\n");
        if (reportForHuman && (this.tuningSql.length() > this.maxSqlPreviewLength || sqlLines.length > this.maxSqlPreviewLines)) {
            report.append("Tuning SQL:\n");
            StringBuilder preview = new StringBuilder();
            if (this.tuningSql.length() > this.maxSqlPreviewLength) {
                preview.append(this.tuningSql.substring(0, this.maxSqlPreviewLength) + "... [" + (this.tuningSql.length() - this.maxSqlPreviewLength) + " characters not displayed]");
            } else {
                for (int i = 0; i < this.maxSqlPreviewLines; ++i) {
                    preview.append(sqlLines[i] + "\n");
                }
                preview.append(" [" + (sqlLines.length - this.maxSqlPreviewLines) + " lines not displayed]");
            }
            report.append((CharSequence)preview).append("\n");
        } else {
            report.append("Tuning SQL:\n").append(this.tuningSql).append("\n");
        }
        report.append("-----------------------------------------\n");
        for (TuningRecord record : sortedRecords) {
            if (record.isExplainTune) continue;
            String startTime = record.beginTimestamp > 0L ? sdf.format(new Date(record.beginTimestamp)) : "N/A";
            String endTime = record.endTimestamp > 0L ? sdf.format(new Date(record.endTimestamp)) : "N/A";
            long latency = record.endTimestamp - record.beginTimestamp;
            String latencyStr = latency > 0L ? latency + " ms" : "N/A";
            String latencyIncreasePctStr = "N/A";
            if (bestLatency > 0L && latency > 0L) {
                double latencyIncreasePct = (double)(latency - bestLatency) * 100.0 / (double)bestLatency;
                latencyIncreasePctStr = String.format("%.2f%%", latencyIncreasePct);
            }
            report.append("Candidate Plan #").append(record.planNumber).append(":\n");
            report.append("Tuning Hints: ").append(record.hintToSetting());
            report.append("Is Current Setting: ").append(record.isCurrentSetting).append("\n");
            report.append("Start Time: ").append(startTime).append("\n");
            report.append("End Time: ").append(endTime).append("\n");
            report.append("Latency: ").append(latencyStr).append("\n");
            report.append("Latency Increase: ").append(latencyIncreasePctStr).append("\n");
            report.append("Resource Cost: ").append(record.resourceCost.getFormattedString()).append("\n");
            if (!reportForHuman) {
                report.append("Plan: \n").append(record.candidatePlan).append("\n");
            }
            report.append("Logview: ").append(record.logviewUrl).append("\n");
            report.append("-----------------------------------------\n");
        }
        if (planNotDisplayed > 0) {
            report.append(planNotDisplayed).append(" plan(s) with suboptimal latency/resource relative to current setting plan were not displayed.\n");
        }
        return report.toString();
    }
}

