/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils.jline;

import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.SignalUtil;
import com.aliyun.openservices.odps.console.utils.jline.ODPSDefaultHighlighter;
import com.aliyun.openservices.odps.console.utils.jline.ODPSDefaultParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import org.jline.builtins.Completers;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import sun.misc.SignalHandler;

public class ODPSLineReader {
    private LineReader lineReader;
    private LineReader confirmationReader;
    private static ODPSLineReader odpsLineReader = null;

    private ODPSLineReader() {
        LineReaderBuilder lineReaderBuilder = LineReaderBuilder.builder();
        this.setOptions(lineReaderBuilder);
        this.confirmationReader = lineReaderBuilder.build();
        this.setCompleter(lineReaderBuilder);
        this.setHighlighter(lineReaderBuilder);
        this.setHistory(lineReaderBuilder);
        this.setParser(lineReaderBuilder);
        this.lineReader = lineReaderBuilder.build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.lineReader.getHistory().save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }

    public History getHistory() {
        return this.lineReader.getHistory();
    }

    public void registerSignalHandler(Terminal.Signal signal, Terminal.SignalHandler handler) {
        this.lineReader.getTerminal().handle(signal, handler);
    }

    public String readLine(String prompt, boolean isConfirmation) {
        return this.readLine(prompt, null, isConfirmation);
    }

    public String readLine(String prompt, Character mask) {
        return this.readLine(prompt, mask, false);
    }

    public String readLine(String prompt, Character mask, boolean isConfirmation) {
        try {
            if (!isConfirmation) {
                return this.lineReader.readLine(this.stylePrompt(prompt), mask);
            }
            return this.confirmationReader.readLine(prompt, mask);
        }
        catch (UserInterruptException e) {
            if (StringUtils.isNullOrEmpty((String)e.getPartialLine())) {
                return null;
            }
            return "";
        }
        catch (EndOfFileException e) {
            return null;
        }
    }

    private String stylePrompt(String prompt) {
        return new AttributedStringBuilder().style(new AttributedStyle().foreground(2).bold()).append((CharSequence)prompt).toAnsi();
    }

    private void setParser(LineReaderBuilder readerBuilder) {
        ODPSDefaultParser parser = new ODPSDefaultParser();
        readerBuilder.parser((Parser)parser);
    }

    private void setCompleter(LineReaderBuilder readerBuilder) {
        Completer completer = this.getCommandCompleter();
        readerBuilder.completer(completer);
    }

    private Completer getCommandCompleter() {
        ArrayList<Object> customCompletor = new ArrayList<Object>();
        HashSet<String> candidateStrings = new HashSet<String>();
        try {
            for (String key : CommandParserUtils.getAllCommandKeyWords()) {
                candidateStrings.add(key.toUpperCase());
                candidateStrings.add(key.toLowerCase());
            }
        }
        catch (AssertionError e) {
            return null;
        }
        if (!candidateStrings.isEmpty()) {
            customCompletor.add(new StringsCompleter(candidateStrings));
        }
        customCompletor.add(new Completers.FileNameCompleter());
        return new AggregateCompleter(customCompletor);
    }

    private void setHighlighter(LineReaderBuilder readerBuilder) {
        ODPSDefaultHighlighter highlighter = new ODPSDefaultHighlighter();
        readerBuilder.highlighter((Highlighter)highlighter);
    }

    private void setOptions(LineReaderBuilder readerBuilder) {
        readerBuilder.option(LineReader.Option.DISABLE_EVENT_EXPANSION, true);
        readerBuilder.option(LineReader.Option.CASE_INSENSITIVE_SEARCH, true);
        readerBuilder.option(LineReader.Option.CASE_INSENSITIVE, true);
    }

    private void setHistory(LineReaderBuilder readerBuilder) {
        String historyfile = ".odpscmd.history";
        Path homeDir = Paths.get(System.getProperty("user.home"), new String[0]);
        if (Files.isSymbolicLink(homeDir)) {
            try {
                homeDir = homeDir.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Can not get user.home real path");
            }
        }
        readerBuilder.variable("history-file", (Object)homeDir.resolve(historyfile));
    }

    public static ODPSLineReader getInstance() {
        if (odpsLineReader == null) {
            odpsLineReader = new ODPSLineReader();
            SignalHandler defaultIntHandler = SignalUtil.getDefaultIntSignalHandler(Thread.currentThread());
            SignalUtil.registerSignalHandler("INT", defaultIntHandler);
        }
        return odpsLineReader;
    }
}

