/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils.antlr;

import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.CommandSplitter;
import com.aliyun.openservices.odps.console.utils.LogUtil;
import com.aliyun.openservices.odps.console.utils.RawStringCommandSplitter;
import java.util.List;

public class AntlrObject {
    private String rawCommand;
    private CommandSplitter splitter;
    private RawStringCommandSplitter rawStringCommandSplitter;

    public AntlrObject(String rawCommand) {
        this.rawCommand = rawCommand;
        this.splitter = new CommandSplitter(rawCommand);
        this.rawStringCommandSplitter = new RawStringCommandSplitter(rawCommand);
    }

    public String[] getTokenStringArray() throws ODPSConsoleException {
        try {
            return this.splitter.getTokens().toArray(new String[0]);
        }
        catch (ODPSConsoleException e) {
            try {
                return this.rawStringCommandSplitter.getTokens().toArray(new String[0]);
            }
            catch (Exception e1) {
                throw e;
            }
        }
    }

    public String[] getRawTokenStringArray() throws ODPSConsoleException {
        return this.rawStringCommandSplitter.getTokens().toArray(new String[0]);
    }

    public List<String> splitCommands() throws ODPSConsoleException {
        return this.splitter.getCommands();
    }

    public List<String> splitCommands(ExecutionContext ctx) throws ODPSConsoleException {
        if (!ctx.isSupportRawString()) {
            return this.splitCommands();
        }
        List<String> commands = null;
        ODPSConsoleException e0 = null;
        try {
            commands = this.splitter.getCommands();
        }
        catch (ODPSConsoleException e1) {
            e0 = e1;
        }
        try {
            List<String> rawCommands = this.rawStringCommandSplitter.getCommands();
            if (this.rawStringCommandSplitter.getFindRawString()) {
                System.out.println("find raw string");
                return rawCommands;
            }
            if (e0 != null) {
                throw e0;
            }
            return commands;
        }
        catch (Exception e) {
            LogUtil.sendFallbackLog(ctx, this.rawCommand, "split commands, find raw string: " + this.rawCommand, e);
            if (e0 == null) {
                return commands;
            }
            throw e0;
        }
    }
}

