/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.jline.ODPSLineReader;
import java.util.Scanner;
import org.jline.reader.History;

public class ODPSConsoleReader {
    private Scanner scanner = null;
    private boolean isWindows = false;

    public ODPSConsoleReader() throws ODPSConsoleException {
        if (ODPSConsoleUtils.isWindows()) {
            this.isWindows = true;
            this.scanner = new Scanner(System.in);
        }
    }

    public String readLine(String prompt) {
        return this.readLine(prompt, null);
    }

    public String readLine(String prompt, Character mask) {
        Thread.interrupted();
        if (this.isWindows) {
            return this.readLineWindows(prompt);
        }
        return ODPSLineReader.getInstance().readLine(prompt, mask);
    }

    private String readLineWindows(String prompt) {
        if (prompt != null) {
            System.err.print(prompt);
        }
        String input = this.scanner.nextLine();
        StringBuilder inputBuffer = new StringBuilder(input);
        while (!input.trim().endsWith(";")) {
            System.err.print(">");
            input = this.scanner.nextLine();
            inputBuffer.append(" ").append(input);
        }
        return inputBuffer.toString();
    }

    public String readConfirmation(String prompt) {
        if (this.isWindows) {
            return this.readConfirmationWindows(prompt);
        }
        return ODPSLineReader.getInstance().readLine(prompt, true);
    }

    public String readConfirmationWindows(String prompt) {
        if (prompt != null) {
            System.err.print(prompt);
        }
        return this.scanner.nextLine();
    }

    public History getHistory() {
        return ODPSLineReader.getInstance().getHistory();
    }
}

