/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;

public class LogUtil {
    public static void sendFallbackLog(ExecutionContext ctx, String command, String msg, Exception e) {
        try {
            HashMap<String, String> msgMap = new HashMap<String, String>();
            msgMap.put("command", command);
            msgMap.put("msg", msg);
            msgMap.put("exception", e == null ? "" : ExceptionUtils.getFullStackTrace((Throwable)e));
            LogUtil.sendDeprecatedLogger(ctx, msgMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendDeprecatedLogger(ExecutionContext ctx, Map<String, String> msgMap) throws UnsupportedEncodingException, ODPSConsoleException, OdpsException {
        String resource = ResourceBuilder.buildProjectResource((String)ctx.getProjectName()) + "/logs";
        String deprecatedLogs = new GsonBuilder().disableHtmlEscaping().create().toJson(msgMap);
        byte[] bytes = deprecatedLogs.getBytes("UTF-8");
        ByteArrayInputStream body = new ByteArrayInputStream(bytes);
        Odps odps = OdpsConnectionFactory.createOdps(ctx);
        odps.getRestClient().request(resource, "PUT", null, null, (InputStream)body, (long)bytes.length);
    }
}

