/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class FormatUtils {
    public static final Gson DEFAULT_COMPLEX_TYPE_FORMAT_GSON;
    public static final DateTimeFormatter DATETIME_FORMATTER;
    public static final DateTimeFormatter TIMESTAMP_FORMATTER;
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static String formatRecord(Record record, Map<String, Integer> width, Gson gson, DateTimeFormatter datetimeFormat) {
        StringBuilder sb = new StringBuilder();
        sb.append("| ");
        for (int i = 0; i < record.getColumnCount(); ++i) {
            String res = FormatUtils.formatField(record, i, record.getColumns()[i].getTypeInfo(), gson, datetimeFormat);
            sb.append(res);
            if (res.length() < width.get(record.getColumns()[i].getName())) {
                int extraLen = width.get(record.getColumns()[i].getName()) - res.length();
                while (extraLen-- > 0) {
                    sb.append(" ");
                }
            }
            sb.append(" | ");
        }
        return sb.toString();
    }

    public static String formatField(Record r, int idx, TypeInfo typeInfo) {
        return FormatUtils.formatField(r, idx, typeInfo, DEFAULT_COMPLEX_TYPE_FORMAT_GSON, DATETIME_FORMATTER);
    }

    public static String formatField(Record r, int idx, TypeInfo typeInfo, Gson gson, DateTimeFormatter datetimeFormat) {
        if (r.get(idx) == null) {
            return "NULL";
        }
        switch (typeInfo.getOdpsType()) {
            case DATETIME: {
                ZonedDateTime zdt = ((ArrayRecord)r).getDatetimeAsZonedDateTime(idx);
                return datetimeFormat.format(zdt);
            }
            case TIMESTAMP: {
                Instant instant = ((ArrayRecord)r).getTimestampAsInstant(idx);
                return TIMESTAMP_FORMATTER.format(instant);
            }
            case TIMESTAMP_NTZ: {
                LocalDateTime localDateTime = ((ArrayRecord)r).getTimestampNtz(idx);
                return localDateTime.format(TIMESTAMP_FORMATTER);
            }
            case ARRAY: 
            case MAP: 
            case STRUCT: {
                return gson.toJson(r.get(idx));
            }
            case STRING: {
                return r.getString(idx);
            }
        }
        return r.get(idx).toString();
    }

    public static JsonElement normalizeStruct(Object object, JsonSerializationContext context) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        Struct struct = (Struct)object;
        for (int i = 0; i < struct.getFieldCount(); ++i) {
            values.put(struct.getFieldName(i), struct.getFieldValue(i));
        }
        return context.serialize(values);
    }

    static {
        DATETIME_FORMATTER = DateTimeFormatter.ofPattern(TIME_PATTERN).withZone(ZoneId.systemDefault()).withResolverStyle(ResolverStyle.LENIENT);
        TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().appendPattern(TIME_PATTERN).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter().withZone(ZoneId.systemDefault());
        JsonSerializer dateSerializer = (date, type, jsonSerializationContext) -> {
            if (date == null) {
                return null;
            }
            return new JsonPrimitive(date.toString());
        };
        JsonSerializer dateTimeSerializer = (date, type, jsonSerializationContext) -> {
            if (date == null) {
                return null;
            }
            return new JsonPrimitive(DATETIME_FORMATTER.format((TemporalAccessor)date));
        };
        JsonSerializer timestampSerializer = (timestamp, type, jsonSerializationContext) -> {
            if (timestamp == null) {
                return null;
            }
            return new JsonPrimitive(TIMESTAMP_FORMATTER.format((TemporalAccessor)timestamp));
        };
        JsonSerializer structSerializer = (struct, type, jsonSerializationContext) -> {
            if (struct == null) {
                return null;
            }
            return FormatUtils.normalizeStruct(struct, jsonSerializationContext);
        };
        DEFAULT_COMPLEX_TYPE_FORMAT_GSON = new GsonBuilder().registerTypeAdapter(LocalDate.class, (Object)dateSerializer).registerTypeAdapter(ZonedDateTime.class, (Object)dateTimeSerializer).registerTypeAdapter(Instant.class, (Object)timestampSerializer).registerTypeAdapter(SimpleStruct.class, (Object)structSerializer).serializeNulls().disableHtmlEscaping().create();
    }

    public static class FormattedResultSet
    implements Iterator<String> {
        private ResultSet resultSet;
        private Gson gson;
        private DateTimeFormatter datetimeFormat;
        private Map<String, Integer> width;
        private String frame;
        private String title;
        private long numLinesReturned = 0L;

        public FormattedResultSet(ResultSet resultSet, Gson gson, DateTimeFormatter datetimeFormat) {
            this.resultSet = resultSet;
            this.gson = gson;
            this.datetimeFormat = datetimeFormat;
            this.width = ODPSConsoleUtils.getDisplayWidth(resultSet.getTableSchema().getColumns(), null, null);
            this.frame = ODPSConsoleUtils.makeOutputFrame(this.width);
            this.title = ODPSConsoleUtils.makeTitle(resultSet.getTableSchema().getColumns(), this.width);
        }

        @Override
        public boolean hasNext() {
            return this.resultSet.hasNext() || this.numLinesReturned < this.resultSet.getRecordCount() + 4L;
        }

        @Override
        public String next() {
            String line;
            if (this.numLinesReturned == 0L || this.numLinesReturned == 2L || this.numLinesReturned == this.resultSet.getRecordCount() + 3L) {
                line = this.frame;
            } else if (this.numLinesReturned == 1L) {
                line = this.title;
            } else if (this.numLinesReturned < this.resultSet.getRecordCount() + 3L) {
                line = FormatUtils.formatRecord(this.resultSet.next(), this.width, this.gson, this.datetimeFormat);
            } else {
                throw new NoSuchElementException("No more elements");
            }
            ++this.numLinesReturned;
            return line;
        }

        public long getRecordCount() {
            return this.resultSet.getRecordCount();
        }
    }
}

