/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.ReentrantLock;

public class FileStorage<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final String filePath;
    private final Class<T> clazz;

    public FileStorage(String filePath, Class<T> clazz) {
        this.filePath = filePath;
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(T data) throws IOException {
        this.lock.lock();
        try {
            boolean created;
            File file = new File(this.filePath);
            Files.createDirectories(Paths.get(file.getParent(), new String[0]), new FileAttribute[0]);
            if (!file.exists() && !(created = file.createNewFile())) {
                throw new IOException("Failed to create new file: " + this.filePath);
            }
            try (FileWriter writer = new FileWriter(this.filePath);){
                this.gson.toJson(data, (Appendable)writer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    public T load() throws IOException {
        this.lock.lock();
        try {
            Object object;
            File file = new File(this.filePath);
            if (!file.exists()) {
                T t = null;
                return t;
            }
            try (FileReader reader = new FileReader(file);){
                object = this.gson.fromJson((Reader)reader, this.clazz);
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

