/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import java.util.ArrayList;
import java.util.List;

public class CommandSplitter {
    private String input;
    private State state;
    private Character quoteType;
    private StringBuilder commandBuffer;
    private ArrayList<String> commandResults;
    private StringBuilder tokenBuffer;
    private ArrayList<String> tokenResults;
    private boolean parsed;

    public CommandSplitter(String input) {
        this.input = input;
        this.state = State.START;
        this.quoteType = null;
        this.commandBuffer = new StringBuilder();
        this.commandResults = new ArrayList();
        this.tokenBuffer = new StringBuilder();
        this.tokenResults = new ArrayList();
        this.parsed = StringUtils.isNullOrEmpty((String)input);
    }

    private void flushBuffer(StringBuilder buffer, ArrayList<String> results, boolean isTrim) {
        if (buffer.length() > 0) {
            String s = buffer.toString();
            String t = s.trim();
            if (t.length() > 0) {
                if (isTrim) {
                    results.add(t);
                } else {
                    results.add(s);
                }
            }
            buffer.setLength(0);
        }
    }

    private void flushTokenBuffer() {
        this.flushBuffer(this.tokenBuffer, this.tokenResults, true);
    }

    private void flushCommandBuffer() {
        this.flushBuffer(this.commandBuffer, this.commandResults, false);
    }

    private void normalSwitch(char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                this.state = State.QUOTE;
                this.quoteType = Character.valueOf(c);
                this.commandBuffer.append(c);
                this.flushTokenBuffer();
                this.tokenBuffer.append(c);
                break;
            }
            case '-': {
                this.state = State.PRE_COMMENT;
                break;
            }
            case ';': {
                this.state = State.NORMAL;
                this.flushCommandBuffer();
                this.flushTokenBuffer();
                break;
            }
            case '(': 
            case ')': {
                this.state = State.NORMAL;
                this.commandBuffer.append(c);
                this.flushTokenBuffer();
                this.tokenResults.add(String.valueOf(c));
                break;
            }
            case '\t': 
            case '\f': 
            case ' ': {
                this.state = State.NORMAL;
                this.commandBuffer.append(c);
                this.flushTokenBuffer();
                break;
            }
            case '\n': 
            case '\r': {
                this.state = State.END;
                this.commandBuffer.append(c);
                this.flushTokenBuffer();
                break;
            }
            default: {
                this.state = State.NORMAL;
                this.commandBuffer.append(c);
                this.tokenBuffer.append(c);
            }
        }
    }

    private void parse() throws ODPSConsoleException {
        block16: for (int i = 0; i < this.input.length(); ++i) {
            char c = this.input.charAt(i);
            switch (this.state) {
                case START: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            this.commandBuffer.append(c);
                            continue block16;
                        }
                        case '#': {
                            this.state = State.COMMENT;
                            continue block16;
                        }
                    }
                    this.normalSwitch(c);
                    continue block16;
                }
                case PRE_COMMENT: {
                    if (c == '-') {
                        this.state = State.COMMENT;
                        this.flushTokenBuffer();
                        continue block16;
                    }
                    this.state = State.NORMAL;
                    this.commandBuffer.append('-');
                    this.tokenBuffer.append('-');
                    --i;
                    continue block16;
                }
                case COMMENT: {
                    if (c != '\n' && c != '\r') continue block16;
                    this.commandBuffer.append(c);
                    this.state = State.END;
                    continue block16;
                }
                case END: {
                    if (c != '\n' && c != '\r') {
                        this.state = State.START;
                        --i;
                        continue block16;
                    }
                    this.commandBuffer.append(c);
                    continue block16;
                }
                case QUOTE: {
                    this.tokenBuffer.append(c);
                    this.commandBuffer.append(c);
                    if (c == this.quoteType.charValue()) {
                        this.state = State.NORMAL;
                        this.flushTokenBuffer();
                        continue block16;
                    }
                    if (c != '\\') continue block16;
                    this.state = State.ESCAPE;
                    continue block16;
                }
                case ESCAPE: {
                    this.tokenBuffer.append(c);
                    this.commandBuffer.append(c);
                    this.state = State.QUOTE;
                    continue block16;
                }
                case NORMAL: {
                    this.normalSwitch(c);
                    continue block16;
                }
                default: {
                    throw new IllegalArgumentException(String.format("impossible thing happened. pos=%s, char='%s'", i, Character.valueOf(c)));
                }
            }
        }
        switch (this.state) {
            case QUOTE: 
            case ESCAPE: {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  string not closed");
            }
        }
        this.flushTokenBuffer();
        this.flushCommandBuffer();
        this.parsed = true;
    }

    public List<String> getCommands() throws ODPSConsoleException {
        if (!this.parsed) {
            this.parse();
        }
        return this.commandResults;
    }

    public List<String> getTokens() throws ODPSConsoleException {
        if (!this.parsed) {
            this.parse();
        }
        return this.tokenResults;
    }

    static enum State {
        START,
        QUOTE,
        ESCAPE,
        NORMAL,
        PRE_COMMENT,
        COMMENT,
        END;

    }
}

