/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jline.reader.UserInterruptException;

public class CommandExecutor {
    public static ExecutorResult run(String cmd) throws IOException {
        return CommandExecutor.run(cmd, false);
    }

    public static ExecutorResult run(String cmd, boolean print) throws IOException {
        return CommandExecutor.run(cmd.split("\\s+"), print);
    }

    public static ExecutorResult run(String cmd, boolean print, File dir) throws IOException {
        return CommandExecutor.run(cmd.split("\\s+"), print, dir);
    }

    public static ExecutorResult run(String[] cmd, boolean print) throws IOException {
        return CommandExecutor.run(cmd, print, null);
    }

    public static ExecutorResult run(String[] cmd, boolean print, File dir) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec(cmd, null, dir);
        StringBuffer outSB = new StringBuffer();
        StringBuffer errSB = new StringBuffer();
        InputStreamReader osr = new InputStreamReader(proc.getInputStream());
        InputStreamReader esr = new InputStreamReader(proc.getErrorStream());
        ExecReader outReader = new ExecReader(osr, outSB, print);
        ExecReader errReader = new ExecReader(esr, errSB, print);
        outReader.start();
        errReader.start();
        try {
            proc.waitFor();
            outReader.join();
            errReader.join();
        }
        catch (InterruptedException e) {
            throw new UserInterruptException(e.getMessage());
        }
        return new ExecutorResult(proc.exitValue(), outSB.toString(), errSB.toString());
    }

    static class ExecReader
    extends Thread {
        StringBuffer buffer;
        BufferedReader reader;
        boolean print;

        @Override
        public void run() {
            String line = new String();
            try {
                while ((line = this.reader.readLine()) != null) {
                    this.buffer.append(line).append("\n");
                    if (!this.print) continue;
                    System.err.println(line);
                }
            }
            catch (IOException e) {
                System.err.print(e.getMessage());
            }
            catch (NullPointerException e) {
                System.err.print(e.getMessage());
            }
            catch (Exception e) {
                System.err.print(e.getMessage());
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public ExecReader(InputStreamReader isr, StringBuffer sb, boolean prt) {
            this.reader = new BufferedReader(isr);
            this.buffer = sb;
            this.print = prt;
        }
    }

    public static class ExecutorResult {
        private final int ecode;
        private final String outStr;
        private final String errorStr;

        public ExecutorResult(int ecode, String outStr, String errorStr) {
            this.ecode = ecode;
            this.outStr = outStr;
            this.errorStr = errorStr;
        }

        public int getEcode() {
            return this.ecode;
        }

        public String getOutStr() {
            return this.outStr;
        }

        public String getErrorStr() {
            return this.errorStr;
        }
    }
}

