/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.commands.SetenvCommand;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import java.io.PrintStream;

public class UnSetCommand
extends AbstractCommand {
    private static final String UNSET = "unset";
    private static final String UNALIAS = "unalias";
    protected static final String[] HELP_TAGS = new String[]{"unset", "unalias"};
    private final boolean isSet;
    private final String key;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: unset|unalias <key>");
    }

    public UnSetCommand(boolean isSet, String key, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.isSet = isSet;
        this.key = key;
    }

    public static UnSetCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        if (StringUtils.isNullOrEmpty((String)commandString)) {
            return null;
        }
        String[] tokens = new AntlrObject(commandString).getTokenStringArray();
        if (tokens.length != 2) {
            return null;
        }
        UnSetCommand command = null;
        if (UNSET.equalsIgnoreCase(tokens[0])) {
            String key = tokens[1];
            command = new UnSetCommand(true, key.trim(), commandString, sessionContext);
        } else if (UNALIAS.equalsIgnoreCase(tokens[0])) {
            String key = tokens[1];
            command = new UnSetCommand(false, key.trim(), commandString, sessionContext);
        }
        return command;
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        boolean isFound = false;
        if (this.isSet) {
            if (SetenvCommand.unset(this.key)) {
                isFound = true;
            }
            if (SetCommand.setMap.containsKey(this.key)) {
                SetCommand.setMap.remove(this.key);
                isFound = true;
            }
            if ("odps.sql.timezone".equalsIgnoreCase(this.key)) {
                this.getContext().setUserSetSqlTimezone(false);
                this.getContext().setSqlTimezone(this.getContext().getDefaultSqlTimezone());
            }
            if ("odps.instance.priority".equalsIgnoreCase(this.key)) {
                this.getContext().setPriority(ExecutionContext.DEFAULT_PRIORITY);
                this.getContext().setPaiPriority(ExecutionContext.DEFAULT_PAI_PRIORITY);
                isFound = true;
            }
            if ("odps.running.cluster".equalsIgnoreCase(this.key)) {
                this.getContext().setRunningCluster(null);
                isFound = true;
            }
        } else if (SetCommand.aliasMap.containsKey(this.key)) {
            SetCommand.aliasMap.remove(this.key);
            isFound = true;
        }
        if (isFound) {
            this.getWriter().writeError("OK");
        } else {
            this.getWriter().writeError(this.key + " not found.");
        }
    }
}

