/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.regex.Pattern;

public class ShowVersionCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"show", "version"};
    private static Pattern PATTERN = Pattern.compile("\\s*SHOW\\s+VERSION\\s*", 34);

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: show version");
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/com/aliyun/openservices/odps/console/version.txt");
            this.getWriter().writeResult(IOUtils.readStreamAsString((InputStream)is));
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Load odps version-file error", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ShowVersionCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public static ShowVersionCommand parse(List<String> optionList, ExecutionContext sessionContext) {
        if (optionList.contains("-v") && optionList.size() == 1) {
            optionList.remove(optionList.indexOf("-v"));
            return new ShowVersionCommand("-v", sessionContext);
        }
        if (optionList.contains("--version") && optionList.size() == 1) {
            optionList.remove(optionList.indexOf("--version"));
            return new ShowVersionCommand("--version", sessionContext);
        }
        return null;
    }

    public static ShowVersionCommand parse(String cmd, ExecutionContext sessionContext) {
        boolean match = PATTERN.matcher(cmd).matches();
        if (match) {
            return new ShowVersionCommand("show version", sessionContext);
        }
        return null;
    }
}

