/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.commands.UseProjectCommand;
import com.aliyun.openservices.odps.console.constants.ODPSConsoleConstants;
import com.aliyun.openservices.odps.console.output.InPlaceUpdates;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleReader;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.SessionUtils;
import com.aliyun.openservices.odps.console.utils.UpdateChecker;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fusesource.jansi.Ansi;
import org.jline.reader.UserInterruptException;

public class InteractiveCommand
extends AbstractCommand {
    public static boolean quit = false;
    public static boolean isInteractiveMode = false;
    private ODPSConsoleReader consoleReader = null;
    private static Pattern IS_DROP_PARTITION = Pattern.compile("\\s*ALTER\\s+TABLE\\s+[\\w\\.]+\\s+DROP.+", 2);

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        isInteractiveMode = true;
        this.getContext().setStep(0);
        this.getContext().setInteractiveMode(isInteractiveMode);
        this.getWriter().writeError("          __                         __\n ___  ___/ /___   ___ ____ __ _  ___/ /\n/ _ \\/ _  // _ \\ (_-</ __//  ' \\/ _  / \n\\___/\\_,_// .__//___/\\__//_/_/_/\\_,_/  \n         /_/                           ");
        this.getWriter().writeError(ODPSConsoleConstants.ALIYUN_ODPS_UTILITIES_VERSION);
        this.checkUpdate();
        this.consoleReader = ODPSConsoleUtils.getOdpsConsoleReader();
        String inputStr = "";
        String endPoint = this.getContext().getEndpoint();
        if (StringUtils.isNullOrEmpty((String)endPoint)) {
            throw new ODPSConsoleException("Failed: endpoint cannot be null or empty.");
        }
        if (this.getContext().isInitialized()) {
            this.getContext().print();
        } else if (this.getContext().getProjectName() != null && !this.getContext().getProjectName().isEmpty()) {
            String projectName = this.getContext().getProjectName();
            String message = String.format("Connecting to %s, project: %s", endPoint, projectName);
            System.err.println(message);
            try {
                String commandText = "use project " + projectName;
                UseProjectCommand useProjectCommand = new UseProjectCommand(commandText, this.getContext(), projectName);
                useProjectCommand.run();
                System.err.println("Connected!");
            }
            catch (Exception ex) {
                System.err.println("Accessing project '" + projectName + "' failed: " + ex.getMessage());
            }
        }
        if (this.getContext().getAutoSessionMode()) {
            SessionUtils.autoAttachSession(this.getContext(), this.getCurrentOdps());
        }
        if (this.getContext().getLiteMode() == null) {
            this.getContext().setLiteMode(true);
        }
        while (inputStr != null) {
            if (!StringUtils.isNullOrEmpty((String)inputStr) && !inputStr.trim().startsWith("--")) {
                try {
                    if (this.isConfirm(inputStr)) {
                        AbstractCommand command = CommandParserUtils.parseCommand(inputStr, this.getContext());
                        command.execute();
                    }
                    if (quit) {
                        break;
                    }
                }
                catch (UserInterruptException e) {
                    inputStr = "";
                }
                catch (Exception e) {
                    String extraMsg = "";
                    if (e instanceof OdpsException) {
                        extraMsg = String.format(" [ RequestId: %s ]. ", ((OdpsException)((Object)e)).getRequestId());
                    }
                    this.getWriter().writeError("FAILED: " + e.getMessage() + extraMsg);
                    if (StringUtils.isNullOrEmpty((String)e.getMessage())) {
                        this.getWriter().writeError(StringUtils.stringifyException((Throwable)e));
                    }
                    this.getWriter().writeDebug(e);
                }
            }
            if (this.getContext().getProjectName() == null) continue;
            inputStr = this.consoleReader.readLine(this.getPrompt());
        }
        System.err.println();
    }

    private String getPrompt() {
        if (StringUtils.isNullOrEmpty((String)this.getContext().getProjectName())) {
            return ">";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getContext().getProjectName());
        if (this.getContext().isSchemaMode()) {
            builder.append(".").append(ODPSConsoleUtils.getDisplaySchema(this.getContext()));
        }
        builder.append(">");
        return builder.toString();
    }

    private String getConfirmInformation(String commandText) {
        String upCommandText = commandText.trim().toUpperCase();
        if (upCommandText.startsWith("DROP") || upCommandText.startsWith("DELETE") || upCommandText.startsWith("REMOVE") || InteractiveCommand.isDropPartitionCmd(upCommandText)) {
            commandText = commandText.substring(0, commandText.length() - 1).trim();
            return "Confirm to \"" + commandText + "\" (yes/no)? ";
        }
        if (upCommandText.matches("PUT\\s+POLICY\\s+.*") || upCommandText.matches("SET\\s+PROJECTPROTECTION.*") && upCommandText.indexOf("EXCEPTION ") > 0) {
            return "will overwrite the old policy content  (yes/no)? ";
        }
        if (upCommandText.matches("SERVER\\s+DELETE\\s+.*")) {
            return "Confirm to remove server and delete all data permanently (Cannot Undo!). (yes/no)? ";
        }
        return null;
    }

    private boolean isConfirm(String commandText) throws IOException {
        String inputStr;
        String confirmText = this.getConfirmInformation(commandText);
        if (confirmText == null) {
            return true;
        }
        do {
            if ((inputStr = this.consoleReader.readConfirmation(confirmText)) == null) {
                return false;
            }
            if (!"N".equals(inputStr = inputStr.trim().toUpperCase()) && !"NO".equals(inputStr)) continue;
            return false;
        } while (!"Y".equals(inputStr) && !"YES".equals(inputStr));
        return true;
    }

    public InteractiveCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public static InteractiveCommand parse(List<String> paraList, ExecutionContext sessionContext) {
        if (paraList.size() == 0) {
            return new InteractiveCommand("", sessionContext);
        }
        if (paraList.contains("-e") && paraList.indexOf("-e") + 1 == paraList.size()) {
            paraList.remove(paraList.indexOf("-e"));
            return new InteractiveCommand("", sessionContext);
        }
        return null;
    }

    static boolean isDropPartitionCmd(String cmd) {
        boolean r = false;
        if (cmd != null) {
            Matcher m = IS_DROP_PARTITION.matcher(cmd);
            r = m.matches();
        }
        return r;
    }

    private void checkUpdate() {
        UpdateChecker checker;
        String updateUrl = this.getContext().getUpdateUrl();
        if (!StringUtils.isNullOrEmpty((String)updateUrl) && (checker = new UpdateChecker(updateUrl, this.getContext())).shouldPromptUpdate()) {
            String message = String.format("New version %s available! Try it now! %s", checker.getOnlineVersion(), checker.getOnlineDownloadURL());
            if (InPlaceUpdates.isUnixTerminal()) {
                InPlaceUpdates.reprintLineWithColorAsBold(System.err, message, Ansi.Color.CYAN);
            } else {
                this.getWriter().writeError(message);
            }
        }
    }
}

