/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.DirectCommand;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.PluginUtil;
import com.aliyun.openservices.odps.console.utils.antlr.AntlrObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HelpCommand
extends DirectCommand {
    public static final String[] HELP_TAGS = new String[]{"help"};
    private static final String ERR_READ_FILE = "Can not find help file.";
    public List<String> keywords;

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        if (this.keywords == null || this.keywords.size() == 0) {
            InputStream is = null;
            try {
                is = this.getClass().getResourceAsStream("/readme.txt");
                if (is == null) {
                    throw new ODPSConsoleException(ERR_READ_FILE);
                }
                this.getWriter().writeResult(IOUtils.readStreamAsString((InputStream)is));
                this.getWriter().writeResult("\nUse 'help [keywords...] to search for more detail.");
            }
            catch (Exception e) {
                throw new ODPSConsoleException(ERR_READ_FILE);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.keywords.size() == 1 && this.keywords.get(0).equalsIgnoreCase("command")) {
            PluginUtil.printPluginCommandPriority();
        } else {
            CommandParserUtils.printHelpInfo(this.keywords, this.getContext());
        }
    }

    public HelpCommand(String commandText, List<String> keywords, ExecutionContext context) {
        super(commandText, context);
        this.keywords = keywords;
    }

    public static HelpCommand parse(List<String> optionList, ExecutionContext sessionContext) {
        if (optionList.contains("-h") && optionList.size() == 1) {
            optionList.remove(optionList.indexOf("-h"));
            return new HelpCommand("-h", null, sessionContext);
        }
        if (optionList.contains("--help") && optionList.size() == 1) {
            optionList.remove(optionList.indexOf("--help"));
            return new HelpCommand("--help", null, sessionContext);
        }
        return null;
    }

    public static HelpCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        if (commandString.toUpperCase().matches("\\s*H(ELP)?(\\s*|\\s+.+)")) {
            AntlrObject antlr = new AntlrObject(commandString.toLowerCase());
            String[] parts = antlr.getTokenStringArray();
            ArrayList<String> keywords = new ArrayList<String>(Arrays.asList(parts));
            keywords.remove(0);
            return new HelpCommand(commandString, keywords, sessionContext);
        }
        return null;
    }

    public static void printUsage(PrintStream out) {
        out.println("");
        out.println("Usage: help");
        out.println("       help [keyword1 keyword2 ...]");
        out.println("For example:");
        out.println("       help");
        out.println("       help create table");
    }
}

