/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.upload;

import com.aliyun.odps.ship.common.BlockInfo;
import com.aliyun.odps.ship.common.Constants;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.ship.upload.RecordReader;
import com.csvreader.CsvReader;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class CsvRecordReader
extends RecordReader {
    private CsvReader csvReader;
    private String currentLine;
    private String charset;
    private boolean ignoreHeader;

    public CsvRecordReader(BlockInfo info, String charset, boolean ignoreHeader) throws IOException {
        super(info);
        this.charset = charset;
        this.ignoreHeader = ignoreHeader;
        this.init();
    }

    @Override
    public String getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public byte[][] readTextRecord() throws IOException {
        if (this.csvReader.readRecord()) {
            String[] values;
            ArrayList line = Lists.newArrayList();
            this.currentLine = this.csvReader.getRawRecord();
            if (this.currentLine.getBytes().length > Constants.MAX_RECORD_SIZE) {
                throw new IllegalArgumentException("ERROR: line bigger than 200M - please check the csv file.");
            }
            for (String v : values = this.csvReader.getValues()) {
                line.add(v.getBytes(this.charset));
                this.readBytes += (long)v.getBytes().length;
            }
            return (byte[][])line.toArray((T[])new byte[line.size()][]);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.csvReader.close();
    }

    private void init() throws IOException {
        this.detectBomCharset();
        this.charset = this.detectedCharset != null ? this.detectedCharset : (Util.isIgnoreCharset(this.charset) ? "utf8" : this.charset);
        BufferedInputStream is = new BufferedInputStream(this.blockInfo.getFileInputStream());
        if (this.bomBytes != 0 && ((InputStream)is).skip(this.bomBytes) != (long)this.bomBytes) {
            throw new IOException(String.format("block %s failed to seek to position %s", this.blockInfo.getBlockId(), this.bomBytes));
        }
        this.csvReader = new CsvReader((InputStream)is, Charset.forName(this.charset));
        this.csvReader.setSafetySwitch(false);
        if (this.ignoreHeader) {
            this.csvReader.readHeaders();
        }
    }
}

