/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.upload;

import com.aliyun.odps.ship.common.BlockInfo;
import com.aliyun.odps.ship.common.Constants;
import com.aliyun.odps.ship.upload.RecordReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class BlockRecordReader
extends RecordReader {
    private byte[] fieldDelimiter;
    private byte[] recordDelimiter;
    boolean ignoreHeader;
    boolean isLastLine;
    byte[] currentLine;
    private BufferedInputStream is;
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0x800000);
    private final int BUF_SIZE = 0x800000;
    private byte[] buf = new byte[0x800000];
    private int bufLength = 0;
    private int offset = 0;
    private int count = 0;

    public BlockRecordReader(BlockInfo blockInfo, String fd, String rd, boolean ignoreHeader) throws IOException {
        super(blockInfo);
        this.fieldDelimiter = fd.getBytes();
        this.recordDelimiter = rd.getBytes();
        this.ignoreHeader = ignoreHeader;
        this.init();
    }

    @Override
    public byte[][] readTextRecord() throws IOException {
        if (this.isLastLine) {
            return null;
        }
        this.currentLine = this.readLine();
        this.isLastLine = this.startPos + this.readBytes > this.blockInfo.getStartPos() + this.blockInfo.getLength();
        return this.splitLine(this.currentLine);
    }

    @Override
    public String getCurrentLine() {
        return new String(this.currentLine);
    }

    protected byte[][] splitLine(byte[] sbl) {
        if (sbl == null) {
            return null;
        }
        ArrayList<byte[]> l = new ArrayList<byte[]>();
        int start = 0;
        int end = 0;
        while (end != -1) {
            end = BlockRecordReader.indexOf(sbl, start, sbl.length, this.fieldDelimiter);
            int colLen = end == -1 ? sbl.length - start : end - start;
            byte[] col = new byte[colLen];
            System.arraycopy(sbl, start, col, 0, colLen);
            l.add(col);
            start = end + this.fieldDelimiter.length;
        }
        return (byte[][])l.toArray((T[])new byte[l.size()][]);
    }

    protected byte[] readLine() throws IOException {
        int foundIndex;
        int lineLength = 0;
        this.byteArrayOutputStream.reset();
        int len = 0;
        while (true) {
            if (this.bufLength == -1) {
                return null;
            }
            foundIndex = 0;
            if (this.offset != this.bufLength && (foundIndex = BlockRecordReader.indexOf(this.buf, this.offset, this.bufLength, this.recordDelimiter)) != -1) break;
            if (this.bufLength - this.offset > this.recordDelimiter.length) {
                if ((lineLength += this.bufLength - this.offset - this.recordDelimiter.length) > Constants.MAX_RECORD_SIZE) {
                    throw new IllegalArgumentException("ERROR: line bigger than 200M - please check record delimiter");
                }
                this.byteArrayOutputStream.write(this.buf, this.offset, this.bufLength - this.recordDelimiter.length - this.offset);
                this.offset = this.bufLength - this.recordDelimiter.length;
            }
            if (this.offset < this.bufLength) {
                System.arraycopy(this.buf, this.offset, this.buf, 0, this.bufLength - this.offset);
            }
            this.bufLength -= this.offset;
            this.offset = 0;
            len = this.is.read(this.buf, this.bufLength, this.buf.length - this.bufLength);
            if (len == -1) {
                if (lineLength + this.bufLength - this.offset > 0) {
                    this.byteArrayOutputStream.write(this.buf, this.offset, this.bufLength - this.offset);
                    this.bufLength = -1;
                    this.readBytes += (long)(lineLength + this.bufLength - this.offset);
                    return this.byteArrayOutputStream.toByteArray();
                }
                return null;
            }
            this.bufLength += len;
        }
        this.byteArrayOutputStream.write(this.buf, this.offset, foundIndex - this.offset);
        this.offset = foundIndex + this.recordDelimiter.length;
        byte[] returnValue = this.byteArrayOutputStream.toByteArray();
        this.readBytes += (long)(returnValue.length + this.recordDelimiter.length);
        return returnValue;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public static int indexOf(byte[] src, int offset, int length, byte[] search) {
        for (int index = offset; index <= length - search.length; ++index) {
            boolean find = true;
            for (int j = 0; j < search.length; ++j) {
                if (src[index + j] == search[j]) continue;
                find = false;
                break;
            }
            if (!find) continue;
            return index;
        }
        return -1;
    }

    private void init() throws IOException {
        this.detectBomCharset();
        this.readBytes = 0L;
        this.is = new BufferedInputStream(this.blockInfo.getFileInputStream());
        this.startPos = 0L;
        if (this.blockInfo.getStartPos() == 0L) {
            if (this.detectedCharset != null) {
                this.startPos = this.bomBytes;
                if (this.is.skip(this.startPos) != this.startPos) {
                    throw new IOException(String.format("block %s failed to seek to position %s", this.blockInfo.getBlockId(), this.startPos));
                }
            }
            if (this.ignoreHeader) {
                this.readLine();
            }
        } else {
            this.startPos = this.blockInfo.getStartPos() - (long)(this.recordDelimiter.length - 1);
            if (this.is.skip(this.startPos) != this.startPos) {
                throw new IOException(String.format("block %s failed to seek to position %s", this.blockInfo.getBlockId(), this.startPos));
            }
            this.readLine();
        }
        this.isLastLine = false;
    }
}

