/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.history;

import com.aliyun.odps.ship.common.SessionStatus;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.ship.history.HistoryComparator;
import com.aliyun.odps.ship.history.SessionHistory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SessionHistoryManager {
    private static List<SessionHistory> listHistory() {
        String sp = Util.getSessionBaseDir() + "/sessions";
        ArrayList<SessionHistory> ls = new ArrayList<SessionHistory>();
        File file = new File(sp);
        if (file.exists()) {
            File[] fl;
            for (File f : fl = file.listFiles()) {
                File[] sfl;
                if (!f.isDirectory() || f.getName().startsWith(".")) continue;
                for (File sf : sfl = f.listFiles()) {
                    ls.add(new SessionHistory(sf.getName()));
                }
            }
        } else {
            return ls;
        }
        Collections.sort(ls, new HistoryComparator());
        return ls;
    }

    public static void showHistory(int n) throws FileNotFoundException, IOException {
        List<SessionHistory> l = SessionHistoryManager.listHistory();
        int size = n > l.size() ? l.size() : n;
        for (int i = 0; i < size; ++i) {
            int idx = l.size() - i - 1;
            Map<String, String> ctx = l.get(idx).loadProperty();
            String status = ctx.get("status");
            if (SessionStatus.success.toString().equals(status) && l.get(idx).existsBad()) {
                status = "bad";
            }
            System.err.println(l.get((int)idx).sid + "\t" + status + "\t'" + ctx.get("command") + "'");
        }
    }

    public static SessionHistory getLatest() throws FileNotFoundException, IOException {
        List<SessionHistory> ls = SessionHistoryManager.listHistory();
        if (ls.size() == 0) {
            throw new FileNotFoundException("ERROR: session not found.");
        }
        return ls.get(ls.size() - 1);
    }

    public static SessionHistory getLatestSilently() throws IOException {
        try {
            return SessionHistoryManager.getLatest();
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static void purgeHistory(int n) throws FileNotFoundException, IOException {
        List<SessionHistory> s = SessionHistoryManager.listHistory();
        Long d = System.currentTimeMillis() - (long)(n * 3600 * 24 * 1000);
        for (SessionHistory sh : s) {
            Map<String, String> ctx = sh.loadProperty();
            String sct = ctx.get("session-create-time");
            if (Long.valueOf(sct) >= d) continue;
            sh.delete();
            System.out.println(sh.sid);
        }
    }

    public static SessionHistory createSessionHistory(String sid) throws FileNotFoundException {
        File f = new File(Util.getSessionDir(sid));
        if (!f.exists() && !f.mkdirs()) {
            throw new FileNotFoundException("ERROR: create session dir fail, dir path is " + f.getPath());
        }
        return new SessionHistory(sid);
    }
}

