/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.common;

import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

public class Util {
    private static String getRootDir() {
        String path = Util.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (path.endsWith(".jar")) {
            String odpscmdRootDir;
            File f;
            if (!Util.isWindows() && (f = new File(odpscmdRootDir = System.getProperty("user.home") + "/.odpscmd/")).exists() && f.isDirectory()) {
                return f.getAbsolutePath() + "/dship";
            }
            try {
                return URLDecoder.decode(path.substring(0, path.lastIndexOf("/")) + "/..", "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new File(ODPSConsoleUtils.getConfigFilePath()).getParent() + "/file";
    }

    public static String getAbsRootDir() {
        try {
            return new File(Util.getRootDir()).getCanonicalPath();
        }
        catch (IOException e) {
            return Util.getRootDir();
        }
    }

    public static String getSessionBaseDir() throws IllegalArgumentException {
        File baseDir;
        String basePath = Util.getAbsRootDir();
        if (DshipContext.INSTANCE.get("session-dir") != null) {
            try {
                basePath = URLDecoder.decode(DshipContext.INSTANCE.get("session-dir"), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (!(baseDir = new File(basePath)).exists()) {
            baseDir.mkdirs();
        } else if (baseDir.isFile()) {
            throw new IllegalArgumentException("SessionDir must be directory, now is a file.");
        }
        return basePath;
    }

    public static String getSessionDir(String sid) throws IllegalArgumentException {
        String subdir;
        if (sid == null) {
            subdir = null;
        } else if (sid.length() > 8) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                format.parse(sid.substring(0, 8));
                subdir = sid.substring(0, 8);
            }
            catch (ParseException e) {
                subdir = sid;
            }
        } else {
            subdir = sid;
        }
        return Util.getSessionBaseDir() + "/sessions/" + subdir + "/" + sid;
    }

    public static String getStack(Exception e) {
        StringWriter errors = new StringWriter();
        PrintWriter w = new PrintWriter(errors);
        e.printStackTrace(w);
        w.close();
        return errors.toString();
    }

    public static File[] sortFiles(File[] fs) {
        if (fs == null) {
            return null;
        }
        List<File> files = Arrays.asList(fs);
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return files.toArray(new File[files.size()]);
    }

    public static void checkSession(String sid) throws FileNotFoundException {
        if (sid == null) {
            return;
        }
        File f = new File(Util.getSessionDir(sid));
        if (!f.exists()) {
            throw new FileNotFoundException("ERROR: session '" + sid + "' not found");
        }
    }

    public static boolean isWindows() {
        String osName = System.getProperties().getProperty("os.name");
        return osName.toLowerCase().indexOf("windows") >= 0;
    }

    public static String toHumanReadableString(String in) {
        String ret = StringEscapeUtils.escapeJava((String)in);
        if (ret == null) {
            return "<null>";
        }
        if (ret.equals("")) {
            return "\"\"(empty string)";
        }
        return "\"" + ret + "\"";
    }

    public static boolean isIgnoreCharset(String charset) {
        return charset == null || charset.toLowerCase().equals("ignore");
    }

    public static String toReadableBytes(long bytes) {
        DecimalFormat df = new DecimalFormat("###,###.#");
        if (bytes < 1024L) {
            return df.format(bytes) + " bytes";
        }
        if (bytes < 0x100000L) {
            return df.format((float)bytes / 1024.0f) + " KB";
        }
        if (bytes < 0x40000000L) {
            return df.format((float)bytes / 1024.0f / 1024.0f) + " MB";
        }
        return df.format((float)bytes / 1024.0f / 1024.0f / 1024.0f) + " GB";
    }

    public static String toReadableMilliseconds(long millis) {
        if (millis < 1000L) {
            return millis + " ms";
        }
        if (millis < 60000L) {
            long sec = millis / 1000L;
            return sec + " s " + (millis %= 1000L) + " ms";
        }
        long minute = millis / 60000L;
        long sec = (millis %= 60000L) / 1000L;
        return minute + " m " + sec + " s " + (millis %= 1000L) + " ms";
    }

    public static String toReadableNumber(long number) {
        DecimalFormat df = new DecimalFormat("###,###");
        return df.format(number);
    }

    public static String pluralize(String word, long count) {
        if (count == 1L) {
            return count + " " + word;
        }
        return count + " " + word + "s";
    }
}

