/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Collections2 {
    private Collections2() {
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList target = new ArrayList();
        iterator.forEachRemaining(target::add);
        return target;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> immutableMapCopy(Map<K, V> map) {
        HashMap<K, V> newMap = new HashMap<K, V>();
        newMap.putAll(map);
        return Collections.unmodifiableMap(newMap);
    }

    public static <V> List<V> immutableListCopy(List<V> list) {
        return Collections.unmodifiableList(list.stream().collect(Collectors.toList()));
    }

    public static <V> List<V> asImmutableList(V ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }
}

