/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.CredentialException;
import com.aliyun.auth.credentials.http.CompatibleUrlConnClient;
import com.aliyun.auth.credentials.http.HttpRequest;
import com.aliyun.auth.credentials.http.HttpResponse;
import com.aliyun.auth.credentials.http.MethodType;
import com.aliyun.auth.credentials.provider.HttpCredentialProvider;
import com.aliyun.auth.credentials.utils.AuthUtils;
import com.aliyun.auth.credentials.utils.ParameterHelper;
import com.aliyun.auth.credentials.utils.RefreshResult;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.core.utils.Validate;
import com.google.gson.Gson;
import java.time.Instant;
import java.util.Map;

public class RsaKeyPairCredentialProvider
extends HttpCredentialProvider {
    private int durationSeconds;
    private String regionId;
    private int connectionTimeout;
    private int readTimeout;
    private Credential credential;
    private final String stsEndpoint;
    private final CompatibleUrlConnClient client;

    private RsaKeyPairCredentialProvider(BuilderImpl builder) {
        super(builder);
        int n = this.durationSeconds = builder.durationSeconds == null ? 3600 : builder.durationSeconds;
        if (this.durationSeconds < 900) {
            throw new IllegalArgumentException("Session duration should be in the range of 900s - max session duration.");
        }
        this.regionId = builder.regionId;
        this.connectionTimeout = builder.connectionTimeout == null ? 5000 : builder.connectionTimeout;
        this.readTimeout = builder.readTimeout == null ? 10000 : builder.readTimeout;
        this.credential = (Credential)Validate.notNull((Object)builder.credential, (String)"Credentials must not be null.", (Object[])new Object[0]);
        if (!StringUtils.isEmpty((CharSequence)builder.stsEndpoint)) {
            this.stsEndpoint = builder.stsEndpoint;
        } else {
            String prefix;
            String string = builder.enableVpc != null ? (builder.enableVpc.booleanValue() ? "sts-vpc" : "sts") : (prefix = AuthUtils.isEnableVpcEndpoint() ? "sts-vpc" : "sts");
            this.stsEndpoint = !StringUtils.isEmpty((CharSequence)builder.stsRegionId) ? String.format("%s.%s.aliyuncs.com", prefix, builder.stsRegionId) : (!StringUtils.isEmpty((CharSequence)AuthUtils.getEnvironmentSTSRegion()) ? String.format("%s.%s.aliyuncs.com", prefix, AuthUtils.getEnvironmentSTSRegion()) : "sts.ap-northeast-1.aliyuncs.com");
        }
        this.client = new CompatibleUrlConnClient();
        this.buildRefreshCache();
    }

    public static RsaKeyPairCredentialProvider create(Credential credential) {
        return RsaKeyPairCredentialProvider.builder().credential(credential).build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public RefreshResult<ICredential> refreshCredentials() {
        HttpResponse httpResponse;
        ParameterHelper parameterHelper = new ParameterHelper();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrlParameter("Action", "GenerateSessionAccessKey");
        httpRequest.setUrlParameter("Format", "JSON");
        httpRequest.setUrlParameter("Version", "2015-04-01");
        httpRequest.setUrlParameter("DurationSeconds", String.valueOf(this.durationSeconds));
        httpRequest.setUrlParameter("AccessKeyId", this.credential.accessKeyId());
        httpRequest.setUrlParameter("RegionId", this.regionId);
        String strToSign = parameterHelper.composeStringToSign(MethodType.GET, httpRequest.getUrlParameters());
        String signature = parameterHelper.signString(strToSign, this.credential.accessKeySecret() + "&");
        httpRequest.setUrlParameter("Signature", signature);
        httpRequest.setSysMethod(MethodType.GET);
        httpRequest.setSysConnectTimeout(this.connectionTimeout);
        httpRequest.setSysReadTimeout(this.readTimeout);
        httpRequest.setSysUrl(parameterHelper.composeUrl(this.stsEndpoint, httpRequest.getUrlParameters(), "https"));
        try {
            httpResponse = this.client.syncInvoke(httpRequest);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to connect RsaKeyPair Service: " + e);
        }
        if (httpResponse.getResponseCode() != 200) {
            throw new CredentialException(String.format("Error refreshing credentials from RsaKeyPair, HttpCode: %s, result: %s.", httpResponse.getResponseCode(), httpResponse.getHttpContentString()));
        }
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(httpResponse.getHttpContentString(), Map.class);
        if (null == map || !map.containsKey("SessionAccessKey")) {
            throw new CredentialException(String.format("Error retrieving credentials from RsaKeyPair result: %s.", httpResponse.getHttpContentString()));
        }
        Map credentials = (Map)map.get("SessionAccessKey");
        Instant expiration = ParameterHelper.getUTCDate((String)credentials.get("Expiration")).toInstant();
        Credential credential = Credential.builder().accessKeyId((String)credentials.get("SessionAccessKeyId")).accessKeySecret((String)credentials.get("SessionAccessKeySecret")).build();
        return RefreshResult.builder(credential).staleTime(this.getStaleTime(expiration)).prefetchTime(this.getPrefetchTime(expiration)).build();
    }

    @Override
    public void close() {
        super.close();
        this.client.close();
    }

    private static final class BuilderImpl
    extends HttpCredentialProvider.BuilderImpl<RsaKeyPairCredentialProvider, Builder>
    implements Builder {
        private Integer durationSeconds;
        private String regionId = "cn-hangzhou";
        private Integer connectionTimeout;
        private Integer readTimeout;
        private Credential credential;
        private String stsEndpoint;
        private String stsRegionId;
        private Boolean enableVpc;

        private BuilderImpl() {
        }

        @Override
        public Builder durationSeconds(Integer durationSeconds) {
            if (!StringUtils.isEmpty((Object)durationSeconds)) {
                this.durationSeconds = durationSeconds;
            }
            return this;
        }

        @Override
        public Builder regionId(String regionId) {
            if (!StringUtils.isEmpty((CharSequence)regionId)) {
                this.regionId = regionId;
            }
            return this;
        }

        @Override
        public Builder connectionTimeout(Integer connectionTimeout) {
            if (!StringUtils.isEmpty((Object)connectionTimeout)) {
                this.connectionTimeout = connectionTimeout;
            }
            return this;
        }

        @Override
        public Builder readTimeout(Integer readTimeout) {
            if (!StringUtils.isEmpty((Object)readTimeout)) {
                this.readTimeout = readTimeout;
            }
            return this;
        }

        @Override
        public Builder credential(Credential credential) {
            this.credential = credential;
            return this;
        }

        @Override
        public Builder stsEndpoint(String stsEndpoint) {
            this.stsEndpoint = stsEndpoint;
            return this;
        }

        @Override
        public Builder stsRegionId(String stsRegionId) {
            this.stsRegionId = stsRegionId;
            return this;
        }

        @Override
        public Builder enableVpc(Boolean enableVpc) {
            this.enableVpc = enableVpc;
            return this;
        }

        @Override
        public RsaKeyPairCredentialProvider build() {
            return new RsaKeyPairCredentialProvider(this);
        }
    }

    public static interface Builder
    extends HttpCredentialProvider.Builder<RsaKeyPairCredentialProvider, Builder> {
        public Builder durationSeconds(Integer var1);

        public Builder regionId(String var1);

        public Builder connectionTimeout(Integer var1);

        public Builder readTimeout(Integer var1);

        public Builder credential(Credential var1);

        public Builder stsEndpoint(String var1);

        public Builder stsRegionId(String var1);

        public Builder enableVpc(Boolean var1);

        @Override
        public RsaKeyPairCredentialProvider build();
    }
}

