/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.mapreduce.runtime;

import com.aliyun.odps.ArchiveResource;
import com.aliyun.odps.FileResource;
import com.aliyun.odps.JarResource;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PyResource;
import com.aliyun.odps.Resource;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.mapreduce.runtime.MapReduceJobLauncher;
import com.aliyun.openservices.odps.console.mr.MapReduceCommand;
import com.aliyun.openservices.odps.console.utils.CommandExecutor;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jline.reader.UserInterruptException;

public class MapReduceJob
implements MapReduceJobLauncher {
    private ExecutionContext context;
    private MapReduceCommand mrCmd;
    private Odps odps;

    public MapReduceJob(MapReduceCommand mrCmd) throws ODPSConsoleException {
        this.context = mrCmd.getContext();
        this.mrCmd = mrCmd;
        this.odps = mrCmd.getCurrentOdps();
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        String prjName = this.context.getProjectName();
        if (prjName == null || prjName.trim().equals("")) {
            throw new ODPSConsoleException("Project not be set! ");
        }
        this.addTempResources();
        this.makeAlias4TempResources();
        try {
            this.runMRTask();
        }
        finally {
            this.makeUnalias4TempResources();
            this.dropTempResources();
        }
    }

    private void addTempResources() throws ODPSConsoleException, OdpsException {
        Map<String, List<String>> tempResources = this.mrCmd.getTempResources();
        if (!tempResources.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : tempResources.entrySet()) {
                String resAlias = entry.getKey();
                List<String> resInfo = entry.getValue();
                Resource.Type type = Resource.Type.valueOf((String)resInfo.get(0).toUpperCase());
                PyResource resource = null;
                switch (type) {
                    case PY: {
                        resource = new PyResource();
                        break;
                    }
                    case JAR: {
                        resource = new JarResource();
                        break;
                    }
                    case ARCHIVE: {
                        resource = new ArchiveResource();
                        break;
                    }
                    case FILE: {
                        resource = new FileResource();
                        break;
                    }
                    default: {
                        throw new ODPSConsoleException("unsupported resource type: " + type);
                    }
                }
                resource.setIsTempResource(true);
                String resName = UUID.randomUUID().toString() + "_" + resAlias;
                resource.setName(resName);
                File resFile = new File(entry.getValue().get(1));
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(resFile);
                    this.odps.resources().create((FileResource)resource, (InputStream)inputStream);
                }
                catch (IOException ex) {
                    throw new ODPSConsoleException("File upload fail", (Throwable)ex);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                resInfo.set(1, resName);
            }
        }
    }

    private void makeAlias4TempResources() {
        Map<String, List<String>> tempResources = this.mrCmd.getTempResources();
        if (!tempResources.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : tempResources.entrySet()) {
                SetCommand.aliasMap.put(entry.getKey(), entry.getValue().get(1));
            }
        }
    }

    private void makeUnalias4TempResources() {
        Map<String, List<String>> tempResources = this.mrCmd.getTempResources();
        if (!tempResources.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : tempResources.entrySet()) {
                SetCommand.aliasMap.remove(entry.getKey());
            }
        }
    }

    private void dropTempResources() {
        Map<String, List<String>> tempResources = this.mrCmd.getTempResources();
        if (!tempResources.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : tempResources.entrySet()) {
                try {
                    this.odps.resources().delete(entry.getValue().get(1));
                }
                catch (Exception exception) {}
            }
        }
    }

    private void runMRTask() throws OdpsException, ODPSConsoleException {
        StringBuffer cmd = new StringBuffer("java");
        cmd.append(" -Dodps.project.name=").append(this.str(this.context.getProjectName()));
        cmd.append(" -Dodps.end.point=").append(this.str(this.context.getEndpoint()));
        if (this.context.getLogViewHost() != null) {
            cmd.append(" -Dodps.logview.host=").append(this.str(this.context.getLogViewHost()));
        }
        if (this.mrCmd.getResources() != null && !this.mrCmd.getResources().trim().equals("")) {
            cmd.append(" -Dodps.cache.resources=" + this.mrCmd.getResources());
        }
        if (this.mrCmd.getLibjars() != null && !this.mrCmd.getLibjars().trim().equals("")) {
            cmd.append(" -Dodps.classpath.resources=" + this.mrCmd.getLibjars());
        }
        if (this.mrCmd.getJvmOptions() != null) {
            for (String jvmOpt : this.mrCmd.getJvmOptions()) {
                cmd.append(" " + jvmOpt);
            }
        }
        if (this.mrCmd.isLocalMode()) {
            cmd.append(" -Dodps.runner.mode=local");
        }
        if (this.mrCmd.isCostMode()) {
            cmd.append(" -Dcost=true");
        }
        if (!this.mrCmd.getConf().isEmpty()) {
            cmd.append(" -Dodps.mr.job.conf=" + this.mrCmd.getConf());
        }
        switch (this.context.getAccountProvider()) {
            case ALIYUN: {
                cmd.append(" -Dodps.account.provider=aliyun");
                break;
            }
            case STS: {
                cmd.append(" -Dodps.account.provider=sts");
                cmd.append(" -Dodps.sts.token=").append(this.str(this.context.getStsToken()));
                break;
            }
            default: {
                throw new ODPSConsoleException("Unsupported account provider.");
            }
        }
        cmd.append(" -Dodps.access.id=").append(this.str(this.context.getAccessId()));
        cmd.append(" -Dodps.access.key=").append(this.str(this.context.getAccessKey()));
        cmd.append(" -Dodps.app.access.id=").append(this.str(this.context.getAppAccessId()));
        cmd.append(" -Dodps.app.access.key=").append(this.str(this.context.getAppAccessKey()));
        cmd.append(" -Dorg.apache.commons.logging.Log=org.apache.commons.logging.impl.SimpleLog");
        cmd.append(" -Dorg.apache.commons.logging.simplelog.log.org.apache.http=WARN");
        String fileName = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "tmp_mr_" + System.currentTimeMillis() + "_" + MapReduceJob.getPID() + ".json";
        if (this.writeConfig(fileName)) {
            cmd.append(" -Dodps.exec.context.file=").append(fileName);
        }
        String sep = System.getProperty("path.separator");
        String classpath = "";
        String clt_classpath = System.getProperty("java.class.path");
        if (!StringUtils.isEmpty((String)clt_classpath)) {
            classpath = classpath + (classpath.isEmpty() ? "" : sep) + clt_classpath;
        }
        if (!StringUtils.isEmpty((String)this.mrCmd.getClasspath())) {
            classpath = classpath + (classpath.isEmpty() ? "" : sep) + this.mrCmd.getClasspath();
        }
        if (!classpath.isEmpty()) {
            cmd.append(" -classpath " + classpath);
        }
        if (this.mrCmd.getArgs() != null) {
            cmd.append(" ").append(this.mrCmd.getArgs());
        }
        try {
            CommandExecutor.ExecutorResult result = CommandExecutor.run((String[])this.parseCmd(cmd.toString()), (boolean)true);
            if (result.getEcode() != 0) {
                throw new ODPSConsoleException("Run job failed.", null, result.getEcode());
            }
        }
        catch (IOException io) {
            throw new OdpsException("CommandExecutor read stream failed:" + io.getMessage());
        }
        catch (UserInterruptException ex) {
            throw ex;
        }
        finally {
            new File(fileName).delete();
        }
    }

    private String[] parseCmd(String cmd) throws IOException {
        if (StringUtils.isEmpty((String)(cmd = cmd.trim()))) {
            throw new IOException("cmd is empty, because main class not specified.");
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] ss = StringUtils.splitPreserveAllTokens((String)cmd);
        boolean quot = false;
        StringBuilder buffer = new StringBuilder();
        for (int idx = 0; idx < ss.length; ++idx) {
            if (quot) {
                buffer.append(' ');
            }
            while (idx < ss.length && ss[idx].isEmpty()) {
                if (quot) {
                    buffer.append(' ');
                }
                ++idx;
            }
            if (idx >= ss.length) break;
            String tok = ss[idx];
            if (tok.startsWith("\"") || tok.endsWith("\"")) {
                if (tok.startsWith("\"")) {
                    if (quot) {
                        buffer.append(tok);
                    } else {
                        buffer.append(tok.substring(1));
                    }
                    quot = true;
                }
                if (!tok.endsWith("\"") || tok.length() <= 1) continue;
                quot = false;
                if (tok.startsWith("\"")) {
                    buffer.deleteCharAt(buffer.length() - 1);
                } else {
                    buffer.append(tok.substring(0, tok.length() - 1));
                }
                result.add(buffer.toString());
                buffer = new StringBuilder();
                continue;
            }
            if (quot) {
                buffer.append(tok);
                continue;
            }
            result.add(tok);
        }
        if (quot) {
            throw new IOException("exist unmatched quotations: " + cmd);
        }
        return result.toArray(new String[result.size()]);
    }

    private String str(String s) {
        return s == null ? "" : s;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeConfig(String fileName) throws OdpsException {
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(fileName))));
            JsonObject result = new JsonObject();
            if (!SetCommand.setMap.isEmpty()) {
                String setMapJson = new GsonBuilder().disableHtmlEscaping().create().toJson((Object)SetCommand.setMap);
                result.add("settings", (JsonElement)new JsonParser().parse(setMapJson).getAsJsonObject());
            }
            if (!SetCommand.aliasMap.isEmpty()) {
                String aliasMapJson = new GsonBuilder().disableHtmlEscaping().create().toJson((Object)SetCommand.aliasMap);
                result.add("aliases", (JsonElement)new JsonParser().parse(aliasMapJson).getAsJsonObject());
            }
            result.addProperty("commandText", this.mrCmd.getCommandText());
            result.add("context", (JsonElement)this.context.toJson());
            String config = new GsonBuilder().create().toJson((JsonElement)result);
            out.write(config.getBytes(), 0, config.getBytes().length);
        }
        catch (IOException e) {
            try {
                throw new OdpsException("MapReduce write config error: " + e.getMessage());
                catch (JsonParseException je) {
                    throw new OdpsException("MapReduce write config error: " + je.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return true;
    }

    public static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }
}

