/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.xerial.snappy.PureJavaCrc32C;

public class Checksum {
    private static byte[] TRUE = new byte[]{1};
    private static byte[] FALSE = new byte[]{0};
    private PureJavaCrc32C crc = new PureJavaCrc32C();
    private ByteBuffer buf = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    public void update(int v) {
        this.buf.clear();
        this.buf.putInt(v);
        this.crc.update(this.buf.array(), 0, 4);
    }

    public void update(long v) {
        this.buf.clear();
        this.buf.putLong(v);
        this.crc.update(this.buf.array(), 0, 8);
    }

    public void update(double v) {
        this.buf.clear();
        this.buf.putDouble(v);
        this.crc.update(this.buf.array(), 0, 8);
    }

    public void update(float v) {
        this.buf.clear();
        this.buf.putFloat(v);
        this.crc.update(this.buf.array(), 0, 4);
    }

    public void update(boolean v) {
        this.crc.update(v ? TRUE : FALSE, 0, 1);
    }

    public void update(byte[] b, int off, int len) {
        this.crc.update(b, off, len);
    }

    public long getValue() {
        return this.crc.getValue();
    }

    public void reset() {
        this.crc.reset();
    }
}

