/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.impl;

import com.aliyun.odps.tunnel.TunnelException;

class Slot {
    private String slot;
    private String ip;
    private int port;

    public Slot(String slot, String server) throws TunnelException {
        if (slot.isEmpty() || server.isEmpty()) {
            throw new TunnelException("Slot or Routed server is empty");
        }
        this.slot = slot;
        this.setServer(server);
    }

    public String getSlot() {
        return this.slot;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.ip + ":" + this.port;
    }

    public boolean equals(Slot slot) {
        return this.slot == slot.slot && this.ip == slot.ip && this.port == slot.port;
    }

    public void setServer(String server) throws TunnelException {
        String[] segs = server.split(":");
        if (segs.length != 2) {
            throw new TunnelException("Invalid slot format: " + server);
        }
        if (segs[0].isEmpty()) {
            throw new TunnelException("Empty server ip: " + server);
        }
        this.ip = segs[0];
        this.port = Integer.valueOf(segs[1]);
    }
}

