/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.google.gson.GsonBuilder;
import java.util.Map;

@Root(name="SQLCost", strict=false)
public class SQLCostTask
extends Task {
    @Element(name="Query", required=false)
    @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
    private String query;

    public SQLCostTask() {
        this.setProperty("sqlcostmode", "sqlcostmode");
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public static Instance run(Odps odps, String sql) throws OdpsException {
        String project = odps.getDefaultProject();
        if (project == null) {
            throw new OdpsException("default project required.");
        }
        return SQLCostTask.run(odps, project, sql, "AnonymousSQLCostTask", null);
    }

    public static Instance run(Odps odps, String project, String sql, Map<String, String> hints) throws OdpsException {
        return SQLCostTask.run(odps, project, sql, "AnonymousSQLCostTask", hints);
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints) throws OdpsException {
        SQLCostTask task = new SQLCostTask();
        task.setQuery(sql);
        task.setName(taskName);
        if (hints != null) {
            try {
                String json = new GsonBuilder().disableHtmlEscaping().create().toJson(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        return odps.instances().create(project, task);
    }
}

