/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.accessor;

import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.SimpleJsonValue;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.table.arrow.accessor.ArrowBigIntAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowBitAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowDateDayAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowDecimalAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowDecimalExtensionAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowFloat4Accessor;
import com.aliyun.odps.table.arrow.accessor.ArrowFloat8Accessor;
import com.aliyun.odps.table.arrow.accessor.ArrowIntAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowSmallIntAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowTimestampAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowTimestampExtensionAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowTinyIntAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowVarBinaryAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowVarCharAccessor;
import com.aliyun.odps.table.arrow.accessor.ArrowVectorAccessor;
import com.aliyun.odps.table.record.accessor.ArrowArrayAccessorImpl;
import com.aliyun.odps.table.record.accessor.ArrowMapAccessorImpl;
import com.aliyun.odps.table.record.accessor.ArrowStructAccessorImpl;
import com.aliyun.odps.type.TypeInfo;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class ArrowToRecordConverter {
    public static ArrowVectorAccessor createColumnVectorAccessor(ValueVector vector, TypeInfo typeInfo) {
        return ArrowToRecordConverter.createColumnVectorAccessor(vector, typeInfo, false);
    }

    public static ArrowVectorAccessor createColumnVectorAccessor(ValueVector vector, TypeInfo typeInfo, boolean isExtension) {
        switch (typeInfo.getOdpsType()) {
            case BOOLEAN: {
                return new ArrowBitAccessor((BitVector)vector);
            }
            case TINYINT: {
                return new ArrowTinyIntAccessor((TinyIntVector)vector);
            }
            case SMALLINT: {
                return new ArrowSmallIntAccessor((SmallIntVector)vector);
            }
            case INT: {
                return new ArrowIntAccessor((IntVector)vector);
            }
            case BIGINT: {
                return new ArrowBigIntAccessor((BigIntVector)vector);
            }
            case FLOAT: {
                return new ArrowFloat4Accessor((Float4Vector)vector);
            }
            case DOUBLE: {
                return new ArrowFloat8Accessor((Float8Vector)vector);
            }
            case DECIMAL: {
                if (isExtension && vector instanceof FixedSizeBinaryVector) {
                    return new ArrowDecimalExtensionAccessor((FixedSizeBinaryVector)vector);
                }
                return new ArrowDecimalAccessor((DecimalVector)vector);
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case JSON: {
                return new ArrowVarCharAccessor((VarCharVector)vector);
            }
            case BINARY: {
                return new ArrowVarBinaryAccessor((VarBinaryVector)vector);
            }
            case DATE: {
                return new ArrowDateDayAccessor((DateDayVector)vector);
            }
            case DATETIME: {
                return new ArrowTimestampAccessor((TimeStampVector)vector);
            }
            case TIMESTAMP: 
            case TIMESTAMP_NTZ: {
                if (!isExtension) {
                    return new ArrowTimestampAccessor((TimeStampVector)vector);
                }
                return new ArrowTimestampExtensionAccessor((StructVector)vector);
            }
            case ARRAY: {
                return new ArrowArrayAccessorImpl.ArrowArrayAccessorForRecord((ListVector)vector, typeInfo, isExtension);
            }
            case MAP: {
                return new ArrowMapAccessorImpl.ArrowMapAccessorForRecord((MapVector)vector, typeInfo, isExtension);
            }
            case STRUCT: {
                return new ArrowStructAccessorImpl.ArrowStructAccessorForRecord((StructVector)vector, typeInfo, isExtension);
            }
        }
        throw new UnsupportedOperationException("Datatype not supported: " + typeInfo.getTypeName());
    }

    public static Object getData(ArrowVectorAccessor dataAccessor, TypeInfo typeInfo, int rowId) throws IOException {
        return ArrowToRecordConverter.getData(dataAccessor, typeInfo, rowId, false);
    }

    public static Object getData(ArrowVectorAccessor dataAccessor, TypeInfo typeInfo, int rowId, boolean isExtension) throws IOException {
        if (dataAccessor.isNullAt(rowId)) {
            return null;
        }
        switch (typeInfo.getOdpsType()) {
            case BOOLEAN: {
                return ((ArrowBitAccessor)dataAccessor).getBoolean(rowId);
            }
            case TINYINT: {
                return ((ArrowTinyIntAccessor)dataAccessor).getByte(rowId);
            }
            case SMALLINT: {
                return ((ArrowSmallIntAccessor)dataAccessor).getShort(rowId);
            }
            case INT: {
                return ((ArrowIntAccessor)dataAccessor).getInt(rowId);
            }
            case BIGINT: {
                return ((ArrowBigIntAccessor)dataAccessor).getLong(rowId);
            }
            case FLOAT: {
                return Float.valueOf(((ArrowFloat4Accessor)dataAccessor).getFloat(rowId));
            }
            case DOUBLE: {
                return ((ArrowFloat8Accessor)dataAccessor).getDouble(rowId);
            }
            case DECIMAL: {
                if (isExtension && dataAccessor instanceof ArrowDecimalExtensionAccessor) {
                    return ((ArrowDecimalExtensionAccessor)dataAccessor).getDecimal(rowId);
                }
                return ((ArrowDecimalAccessor)dataAccessor).getDecimal(rowId);
            }
            case STRING: {
                return ((ArrowVarCharAccessor)dataAccessor).getBytes(rowId);
            }
            case VARCHAR: {
                return new Varchar(new String(((ArrowVarCharAccessor)dataAccessor).getBytes(rowId), "utf-8"));
            }
            case CHAR: {
                return new Char(new String(((ArrowVarCharAccessor)dataAccessor).getBytes(rowId), "utf-8"));
            }
            case BINARY: {
                return new Binary(((ArrowVarBinaryAccessor)dataAccessor).getBinary(rowId));
            }
            case DATE: {
                return LocalDate.ofEpochDay(((ArrowDateDayAccessor)dataAccessor).getEpochDay(rowId));
            }
            case DATETIME: {
                return ArrowToRecordConverter.convertToTimeStamp(((ArrowTimestampAccessor)dataAccessor).getType(), ((ArrowTimestampAccessor)dataAccessor).getEpochTime(rowId)).atZone(ZoneId.systemDefault());
            }
            case TIMESTAMP: {
                if (!isExtension) {
                    return ArrowToRecordConverter.convertToTimeStamp(((ArrowTimestampAccessor)dataAccessor).getType(), ((ArrowTimestampAccessor)dataAccessor).getEpochTime(rowId));
                }
                return ((ArrowTimestampExtensionAccessor)dataAccessor).getTimestamp(rowId);
            }
            case TIMESTAMP_NTZ: {
                if (!isExtension) {
                    return ArrowToRecordConverter.convertToTimeStampNtz(((ArrowTimestampAccessor)dataAccessor).getType(), ((ArrowTimestampAccessor)dataAccessor).getEpochTime(rowId));
                }
                return ((ArrowTimestampExtensionAccessor)dataAccessor).getTimestampNtz(rowId);
            }
            case JSON: {
                return new SimpleJsonValue(new String(((ArrowVarCharAccessor)dataAccessor).getBytes(rowId)));
            }
            case ARRAY: {
                return ((ArrowArrayAccessorImpl.ArrowArrayAccessorForRecord)dataAccessor).getArray(rowId);
            }
            case MAP: {
                return ((ArrowMapAccessorImpl.ArrowMapAccessorForRecord)dataAccessor).getMap(rowId);
            }
            case STRUCT: {
                return ((ArrowStructAccessorImpl.ArrowStructAccessorForRecord)dataAccessor).getStruct(rowId);
            }
        }
        throw new UnsupportedOperationException("Datatype not supported: " + typeInfo.getTypeName());
    }

    private static Instant convertToTimeStamp(ArrowType.Timestamp timestampType, long epochTime) {
        switch (timestampType.getUnit()) {
            case SECOND: {
                return Instant.ofEpochSecond(epochTime);
            }
            case MILLISECOND: {
                return Instant.ofEpochMilli(epochTime);
            }
            case MICROSECOND: {
                return ArrowToRecordConverter.microsToInstant(epochTime);
            }
            case NANOSECOND: {
                return ArrowToRecordConverter.nanosToInstant(epochTime);
            }
        }
        throw new UnsupportedOperationException("Unit not supported: " + timestampType.getUnit());
    }

    private static LocalDateTime convertToTimeStampNtz(ArrowType.Timestamp timestampType, long epochTime) {
        return LocalDateTime.ofInstant(ArrowToRecordConverter.convertToTimeStamp(timestampType, epochTime), ZoneOffset.UTC);
    }

    private static Instant microsToInstant(long micros) {
        long secs = Math.floorDiv(micros, 1000000L);
        long mos = micros - secs * 1000000L;
        return Instant.ofEpochSecond(secs, mos * 1000L);
    }

    private static Instant nanosToInstant(long nanos) {
        long secs = Math.floorDiv(nanos, 1000000000L);
        long nos = nanos - secs * 1000000000L;
        return Instant.ofEpochSecond(secs, nos);
    }
}

