/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class WhoamiCommand
implements Command {
    private static final Map<String, TypeInfo> infoMap = new LinkedHashMap<String, TypeInfo>();

    WhoamiCommand() {
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public List<TypeInfo> getResultTypes() {
        return new ArrayList<TypeInfo>(infoMap.values());
    }

    @Override
    public List<String> getResultHeaders() {
        return new ArrayList<String>(infoMap.keySet());
    }

    @Override
    public RecordIter<Record> run(Odps odps, CommandInfo commandInfo) throws OdpsException {
        SecurityManager sm = odps.projects().get().getSecurityManager();
        String result = sm.runQuery(commandInfo.getCommandText(), false);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            JsonObject js = new JsonParser().parse(result).getAsJsonObject();
            map.put("DisplayName", js.has("DisplayName") ? js.get("DisplayName").getAsString() : null);
            map.put("SourceIP", js.has("SourceIP") ? js.get("SourceIP").getAsString() : null);
            map.put("VpcId", js.has("VpcId") ? js.get("VpcId").getAsString() : null);
            map.put("Endpoint", odps.getEndpoint());
            map.put("TunnelEndpoint", odps.projects().get().getTunnelEndpoint(null));
            map.put("Project", odps.getDefaultProject());
            map.put("Schema", StringUtils.isNullOrEmpty((String)odps.getCurrentSchema()) ? "default" : odps.getCurrentSchema());
        }
        catch (JsonParseException e) {
            throw new RuntimeException("parse whoami error:" + e.getMessage());
        }
        return new RecordIter<Record>(CommandUtil.toRecord(map, infoMap).iterator(), this.getResultHeaders(), this.getResultTypes());
    }

    static {
        infoMap.put("DisplayName", (TypeInfo)TypeInfoFactory.STRING);
        infoMap.put("SourceIP", (TypeInfo)TypeInfoFactory.STRING);
        infoMap.put("VpcId", (TypeInfo)TypeInfoFactory.STRING);
        infoMap.put("Endpoint", (TypeInfo)TypeInfoFactory.STRING);
        infoMap.put("TunnelEndpoint", (TypeInfo)TypeInfoFactory.STRING);
        infoMap.put("Project", (TypeInfo)TypeInfoFactory.STRING);
        infoMap.put("Schema", (TypeInfo)TypeInfoFactory.STRING);
    }
}

