/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.task.MergeTask;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class MergeTaskCommand
implements Command {
    private static final String ARCHIVE_SETTINGS = "archiveSettings";
    private String tableName;
    private String partition;
    private String instanceId = "";

    public MergeTaskCommand(String tableName, String partition) {
        this.tableName = tableName;
        this.partition = partition;
    }

    void runJob(Task task, Odps odps) throws OdpsException {
        this.instanceId = CommandUtil.runJob(task, odps);
    }

    private void addSetting(Map<String, String> config, Map<String, String> setting) {
        String origSettings = null;
        String addedSettings = null;
        Map.Entry<String, String> property = null;
        for (Map.Entry<String, String> pr : config.entrySet()) {
            if (!"settings".equals(pr.getKey())) continue;
            property = pr;
            origSettings = pr.getValue();
            break;
        }
        if (property == null || origSettings == null) {
            try {
                addedSettings = new GsonBuilder().disableHtmlEscaping().create().toJson(setting);
            }
            catch (Exception e) {
                return;
            }
            if (addedSettings != null) {
                config.put("settings", addedSettings);
            }
        } else {
            try {
                JsonObject jsonObject = new JsonParser().parse(origSettings).getAsJsonObject();
                for (Map.Entry<String, String> prop : setting.entrySet()) {
                    jsonObject.addProperty(prop.getKey(), prop.getValue());
                }
                addedSettings = jsonObject.toString();
            }
            catch (Exception e) {
                return;
            }
            if (addedSettings != null) {
                property.setValue(addedSettings);
            }
        }
    }

    RecordIter<Record> mergeTaskRun(Odps odps, CommandInfo commandInfo, String taskNamePrefix, Map<String, String> settingMap) {
        int retryTime = odps.getRestClient().getRetryTimes();
        retryTime = retryTime > 0 ? retryTime : 1;
        String tableInfo = this.getTableName() + " " + this.getPartition();
        Map<String, String> settings = commandInfo.getHint();
        while (true) {
            try {
                String taskName = taskNamePrefix + Calendar.getInstance().getTimeInMillis();
                MergeTask task = new MergeTask(taskName, tableInfo);
                HashMap<String, String> map = new HashMap<String, String>(settingMap);
                if (map.containsKey(ARCHIVE_SETTINGS)) {
                    task.setProperty(ARCHIVE_SETTINGS, (String)map.get(ARCHIVE_SETTINGS));
                    map.remove(ARCHIVE_SETTINGS);
                }
                this.addSetting(settings, map);
                for (Map.Entry<String, String> property : settings.entrySet()) {
                    task.setProperty(property.getKey(), property.getValue());
                }
                this.runJob(task, odps);
                Instance instance = odps.instances().get(this.getInstanceId());
                commandInfo.setTaskName(taskName);
                commandInfo.setInstance(instance, odps.logview().generateLogView(instance, 168L), null);
            }
            catch (Exception e) {
                if (--retryTime > 0) continue;
                throw new RuntimeException(e.getMessage());
            }
            break;
        }
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPartition() {
        return this.partition;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public List<String> getResultHeaders() {
        return Collections.singletonList("Info");
    }

    @Override
    public List<TypeInfo> getResultTypes() {
        return Collections.singletonList(TypeInfoFactory.STRING);
    }
}

