/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Quota;
import com.aliyun.odps.sqa.ExecuteMode;
import com.aliyun.odps.sqa.FallbackPolicy;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.odps.sqa.SQLExecutorConstants;
import com.aliyun.odps.sqa.SQLExecutorImpl;
import com.aliyun.odps.sqa.SQLExecutorPool;
import com.aliyun.odps.table.utils.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SQLExecutorBuilder {
    private ExecuteMode executeMode = ExecuteMode.INTERACTIVE;
    private boolean enableReattach = true;
    private boolean useInstanceTunnel = true;
    private Odps odps = null;
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private String taskName = "console_sqlrt_task";
    private String serviceName = "public.default";
    private String tunnelEndpoint = null;
    private String quotaName = null;
    private SQLExecutorPool pool = null;
    private FallbackPolicy fallbackPolicy = FallbackPolicy.alwaysFallbackPolicy();
    private int tunnelGetResultMaxRetryTime = 3;
    private Long attachTimeout = SQLExecutorConstants.DEFAULT_ATTACH_TIMEOUT;
    private String runningCluster = null;
    private Instance recoverInstance = null;
    private boolean useCommandApi = false;
    private boolean odpsNamespaceSchema = false;
    private int tunnelSocketTimeout = -1;
    private int tunnelReadTimeout = -1;
    private boolean sessionSupportNonSelect = false;
    private boolean useMcqaV2 = false;
    private Integer offlineJobPriority = null;
    private String regionId = null;
    private Quota quota = null;
    private int logviewVersion = 1;

    public static SQLExecutorBuilder builder() {
        return new SQLExecutorBuilder();
    }

    public SQLExecutor build() throws OdpsException {
        if (this.useMcqaV2 || this.executeMode == ExecuteMode.INTERACTIVE_V2) {
            Preconditions.checkArgument(this.executeMode != ExecuteMode.OFFLINE, "offline executeMode is not supported in mcqa");
            return new com.aliyun.odps.sqa.v2.SQLExecutorImpl(this);
        }
        return new SQLExecutorImpl(this.odps, this.serviceName, this.taskName, this.tunnelEndpoint, this.properties, this.executeMode, this.fallbackPolicy, this.enableReattach, this.useInstanceTunnel, this.pool, this.recoverInstance, this.runningCluster, this.tunnelGetResultMaxRetryTime, this.useCommandApi, this.quotaName, this.attachTimeout, this.odpsNamespaceSchema, this.tunnelSocketTimeout, this.tunnelReadTimeout, this.sessionSupportNonSelect, this.offlineJobPriority, this.logviewVersion);
    }

    public SQLExecutorBuilder odps(Odps odps) {
        this.odps = odps;
        return this;
    }

    public SQLExecutorBuilder properties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
        return this;
    }

    public SQLExecutorBuilder taskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public SQLExecutorBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public SQLExecutorBuilder tunnelEndpoint(String tunnelEndpoint) {
        this.tunnelEndpoint = tunnelEndpoint;
        return this;
    }

    public SQLExecutorBuilder quota(Quota quota) {
        this.quota = quota;
        this.quotaName = quota.getNickname();
        return this;
    }

    public SQLExecutorBuilder quotaName(String quotaName) {
        this.quotaName = quotaName;
        return this;
    }

    public SQLExecutorBuilder executeMode(ExecuteMode executeMode) {
        this.executeMode = executeMode;
        return this;
    }

    public SQLExecutorBuilder attachTimeout(Long timeout) {
        this.attachTimeout = timeout;
        return this;
    }

    public SQLExecutorBuilder enableCommandApi(boolean useCommandApi) {
        this.useCommandApi = useCommandApi;
        return this;
    }

    public SQLExecutorBuilder enableOdpsNamespaceSchema(boolean odpsNamespaceSchema) {
        this.odpsNamespaceSchema = odpsNamespaceSchema;
        return this;
    }

    public SQLExecutorBuilder enableReattach(boolean enableReattach) {
        this.enableReattach = enableReattach;
        return this;
    }

    public SQLExecutorBuilder recoverFrom(Instance instance) {
        this.recoverInstance = instance;
        return this;
    }

    public SQLExecutorBuilder runningCluster(String runningCluster) {
        this.runningCluster = runningCluster;
        return this;
    }

    public SQLExecutorBuilder useInstanceTunnel(boolean useInstanceTunnel) {
        this.useInstanceTunnel = useInstanceTunnel;
        return this;
    }

    public SQLExecutorBuilder tunnelGetResultMaxRetryTime(int tunnelGetResultMaxRetryTime) {
        this.tunnelGetResultMaxRetryTime = tunnelGetResultMaxRetryTime;
        return this;
    }

    public SQLExecutorBuilder fallbackPolicy(FallbackPolicy fallbackPolicy) {
        this.fallbackPolicy = fallbackPolicy;
        return this;
    }

    SQLExecutorBuilder setPool(SQLExecutorPool pool) {
        this.pool = pool;
        return this;
    }

    public SQLExecutorBuilder tunnelSocketTimeout(int tunnelSocketTimeout) {
        this.tunnelSocketTimeout = tunnelSocketTimeout;
        return this;
    }

    public SQLExecutorBuilder tunnelReadTimeout(int tunnelReadTimeout) {
        this.tunnelReadTimeout = tunnelReadTimeout;
        return this;
    }

    public SQLExecutorBuilder sessionSupportNonSelect(boolean sessionSupportNonSelect) {
        this.sessionSupportNonSelect = sessionSupportNonSelect;
        return this;
    }

    public SQLExecutorBuilder enableMcqaV2(boolean mcqaV2) {
        this.useMcqaV2 = mcqaV2;
        return this;
    }

    public SQLExecutorBuilder offlineJobPriority(Integer offlineJobPriority) {
        this.offlineJobPriority = offlineJobPriority;
        return this;
    }

    public SQLExecutorBuilder regionId(String regionId) {
        this.regionId = regionId;
        return this;
    }

    public SQLExecutorBuilder logviewVersion(int logviewVersion) {
        this.logviewVersion = logviewVersion;
        return this;
    }

    public ExecuteMode getExecuteMode() {
        return this.executeMode;
    }

    public boolean isEnableReattach() {
        return this.enableReattach;
    }

    public boolean isUseInstanceTunnel() {
        return this.useInstanceTunnel;
    }

    public Odps getOdps() {
        return this.odps;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTunnelEndpoint() {
        return this.tunnelEndpoint;
    }

    public String getQuotaName() {
        return this.quotaName;
    }

    public Quota getQuota() {
        return this.quota;
    }

    public SQLExecutorPool getPool() {
        return this.pool;
    }

    public FallbackPolicy getFallbackPolicy() {
        return this.fallbackPolicy;
    }

    public int getTunnelGetResultMaxRetryTime() {
        return this.tunnelGetResultMaxRetryTime;
    }

    public Long getAttachTimeout() {
        return this.attachTimeout;
    }

    public String getRunningCluster() {
        return this.runningCluster;
    }

    public Instance getRecoverInstance() {
        return this.recoverInstance;
    }

    public boolean isUseCommandApi() {
        return this.useCommandApi;
    }

    public boolean isOdpsNamespaceSchema() {
        return this.odpsNamespaceSchema;
    }

    public int getTunnelSocketTimeout() {
        return this.tunnelSocketTimeout;
    }

    public int getTunnelReadTimeout() {
        return this.tunnelReadTimeout;
    }

    public boolean isSessionSupportNonSelect() {
        return this.sessionSupportNonSelect;
    }

    public boolean isUseMcqaV2() {
        return this.useMcqaV2;
    }

    public Integer getOfflineJobPriority() {
        return this.offlineJobPriority;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public int getLogviewVersion() {
        return this.logviewVersion;
    }
}

