/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.transport;

import com.aliyun.odps.Survey;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.DefaultConnection;
import com.aliyun.odps.commons.transport.DefaultResponse;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.transport.Transport;
import com.aliyun.odps.commons.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;

@Survey
public class DefaultTransport
implements Transport {
    private Proxy proxy;

    @Override
    public Connection connect(Request req) throws IOException {
        DefaultConnection conn = new DefaultConnection(this.proxy);
        conn.connect(req);
        return conn;
    }

    @Override
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response request(Request req) throws IOException {
        Connection conn = this.connect(req);
        DefaultResponse resp = null;
        try {
            if (req.getBody() != null) {
                OutputStream out = conn.getOutputStream();
                IOUtils.copyLarge(req.getBody(), out);
                out.close();
            }
            resp = (DefaultResponse)conn.getResponse();
            if (Request.Method.HEAD != req.getMethod()) {
                InputStream in = conn.getInputStream();
                resp.setBody(IOUtils.readFully(in));
            }
        }
        finally {
            conn.disconnect();
        }
        return resp;
    }
}

