/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.account;

import com.aliyun.odps.account.RequestSigner;
import com.aliyun.odps.account.SecurityUtils;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;

public class AliyunRequestSigner
implements RequestSigner {
    private static final Logger log = Logger.getLogger(AliyunRequestSigner.class.getName());
    private final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final String accessId;
    private final String accessKey;
    private String regionName;

    public AliyunRequestSigner(String accessId, String accessKey) {
        this(accessId, accessKey, null);
    }

    public AliyunRequestSigner(String accessId, String accessKey, String regionName) {
        if (StringUtils.isBlank((String)accessId)) {
            throw new IllegalArgumentException("AccessId should not be empty.");
        }
        if (StringUtils.isBlank((String)accessKey)) {
            throw new IllegalArgumentException("AccessKey should not be empty.");
        }
        this.accessId = accessId;
        this.accessKey = accessKey;
        this.regionName = regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    public void sign(String resource, Request req) {
        req.getHeaders().put("Authorization", this.getSignature(resource, req));
    }

    public String getSignature(String resource, Request req) {
        try {
            resource = URLDecoder.decode(resource, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String strToSign = SecurityUtils.buildCanonicalString(resource, req, "x-odps-");
        if (log.isLoggable(Level.FINE)) {
            log.fine("String to sign: " + strToSign);
        }
        if (StringUtils.isNullOrEmpty((String)this.regionName)) {
            return this.calculateSignatureV2(strToSign);
        }
        return this.calculateSignatureV4(strToSign, this.regionName);
    }

    private String calculateSignatureV2(String strToSign) {
        byte[] crypto = SecurityUtils.hmacsha1Signature(strToSign.getBytes(StandardCharsets.UTF_8), this.accessKey.getBytes());
        String signature = Base64.encodeBase64String((byte[])crypto).trim();
        return "ODPS " + this.accessId + ":" + signature;
    }

    private String calculateSignatureV4(String strToSign, String regionName) {
        String currentDate = this.getDate();
        String credential = this.accessId + "/" + currentDate + "/" + regionName + "/odps/aliyun_v4_request";
        byte[] signatureKey = this.getSignatureKey(this.accessKey, currentDate, regionName);
        byte[] signature = SecurityUtils.hmacsha1Signature(strToSign.getBytes(StandardCharsets.UTF_8), signatureKey);
        return "ODPS " + credential + ":" + java.util.Base64.getEncoder().encodeToString(signature);
    }

    private byte[] getSignatureKey(String key, String date, String regionName) {
        byte[] kSecret = ("aliyun_v4" + key).getBytes(StandardCharsets.UTF_8);
        byte[] kDate = SecurityUtils.hmacsha256Signature(date.getBytes(StandardCharsets.UTF_8), kSecret);
        byte[] kRegion = SecurityUtils.hmacsha256Signature(regionName.getBytes(StandardCharsets.UTF_8), kDate);
        byte[] kService = SecurityUtils.hmacsha256Signature("odps".getBytes(StandardCharsets.UTF_8), kRegion);
        return SecurityUtils.hmacsha256Signature("aliyun_v4_request".getBytes(StandardCharsets.UTF_8), kService);
    }

    private String getDate() {
        LocalDateTime utcDate = LocalDateTime.now(ZoneOffset.UTC);
        return utcDate.format(this.dateFormat);
    }
}

