/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Resource;
import com.aliyun.odps.Table;

public class TableResource
extends Resource {
    public TableResource() {
        this(null, null);
    }

    public TableResource(String tableName) {
        this(tableName, null);
    }

    public TableResource(String tableName, String projectName) {
        this(tableName, projectName, null);
    }

    public TableResource(String tableName, String projectName, PartitionSpec partition) {
        this.model.sourceTableName = projectName != null ? projectName + "." + tableName : tableName;
        if (partition == null) {
            this.model.type = Resource.Type.TABLE.toString();
        } else {
            this.model.sourceTableName = this.model.sourceTableName + " partition(" + partition.toString() + ")";
            this.model.type = Resource.Type.TABLE.toString();
        }
    }

    @Deprecated
    public TableResource(Resource resource) {
        super(resource.model, resource.project, resource.odps);
        if (this.model == null || !Resource.Type.TABLE.toString().equalsIgnoreCase(this.getType().toString())) {
            throw new IllegalArgumentException("Resource type is not TABLE");
        }
    }

    String getSourceTableName() {
        if (this.model.sourceTableName == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.sourceTableName;
    }

    public Table getSourceTable() {
        String tableName;
        String schemaName;
        String projectName;
        String src = this.getSourceTableName();
        if (src == null) {
            return null;
        }
        String[] res = src.split(" partition\\(");
        String[] names = (src = res[0]).trim().split("\\.");
        if (names.length == 2) {
            projectName = names[0];
            schemaName = null;
            tableName = names[1];
        } else if (names.length == 3) {
            projectName = names[0];
            schemaName = names[1];
            tableName = names[2];
        } else {
            throw new IllegalArgumentException("Malformed source table name:" + src);
        }
        Table.TableModel tableModel = new Table.TableModel();
        tableModel.name = tableName;
        return new Table(tableModel, projectName, schemaName, this.odps);
    }

    public PartitionSpec getSourceTablePartition() {
        String src = this.getSourceTableName();
        if (src == null) {
            return null;
        }
        String[] res = src.split(" partition\\(");
        if (res.length < 2) {
            return null;
        }
        String partition = res[1];
        int lastindex = partition.lastIndexOf(41);
        if (lastindex >= 0) {
            partition = partition.substring(0, lastindex);
        }
        return new PartitionSpec(partition.trim());
    }
}

