/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Stream;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.table.StreamIdentifier;
import com.aliyun.odps.table.TableIdentifier;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.odps.utils.StringUtils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Streams
implements Iterable<Stream> {
    private final RestClient client;
    private final Odps odps;

    Streams(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Stream get(String streamName) {
        return this.get(this.getDefaultProjectName(), streamName);
    }

    public Stream get(StreamIdentifier identifier) {
        return this.get(identifier.getProject(), identifier.getStreamName());
    }

    public Stream get(String projectName, String streamName) {
        Stream.StreamModel streamModel = new Stream.StreamModel();
        streamModel.name = streamName;
        return new Stream(streamModel, projectName, this.odps);
    }

    public boolean exists(String streamName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), streamName);
    }

    public boolean exists(StreamIdentifier identifier) throws OdpsException {
        return this.exists(identifier.getProject(), identifier.getStreamName());
    }

    public boolean exists(String projectName, String streamName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)streamName)) {
            return false;
        }
        try {
            Stream t = this.get(projectName, streamName);
            t.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public void create(StreamIdentifier identifier, TableIdentifier refTable) throws OdpsException {
        this.create(identifier, refTable, false, null, 1L, ReadMode.APPEND, null);
    }

    public void create(StreamIdentifier identifier, TableIdentifier refTable, boolean ifNotExists, String timestamp, Long version, ReadMode readMode, String comment) throws OdpsException {
        if (StringUtils.isNotBlank((String)timestamp) && version != null) {
            throw new InvalidParameterException("Both timestamp and version cannot be specified at the same time");
        }
        if (StringUtils.isBlank((String)timestamp) && version == null) {
            throw new InvalidParameterException("Neither timestamp nor version can be null");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE STREAM ");
        if (ifNotExists) {
            sql.append("IF NOT EXISTS ");
        }
        sql.append(identifier).append(" ON TABLE ");
        sql.append(refTable);
        if (StringUtils.isNotBlank((String)timestamp)) {
            sql.append(" TIMESTAMP AS OF ").append(timestamp);
        }
        if (version != null) {
            sql.append(" VERSION AS OF ").append(version);
        }
        sql.append(" STRMPROPERTIES(\"read_mode\"=\"").append(readMode.name().toLowerCase()).append("\")");
        if (StringUtils.isNotBlank((String)comment)) {
            sql.append(" COMMENT ").append(comment);
        }
        sql.append(";");
        HashMap<String, String> hints = new HashMap<String, String>();
        NameSpaceSchemaUtils.setSchemaFlagInHints(hints, refTable.getSchema());
        Instance createStreamTask = SQLTask.run(this.odps, identifier.getProject(), sql.toString(), "SQLCreateStreamTask", hints, null);
        createStreamTask.waitForSuccess();
    }

    public void delete(String streamName) throws OdpsException {
        this.delete(this.getDefaultProjectName(), streamName, false);
    }

    public void delete(String streamName, boolean ifExists) throws OdpsException {
        this.delete(this.getDefaultProjectName(), streamName, ifExists);
    }

    public void delete(String projectName, String streamName, boolean ifExists) throws OdpsException {
        StringBuilder sql = new StringBuilder("DROP STREAM ");
        if (ifExists) {
            sql.append("IF EXISTS ");
        }
        sql.append(streamName);
        sql.append(";");
        Instance dropStreamTask = SQLTask.run(this.odps, projectName, sql.toString(), "SQLDropStreamTask", null, null);
        dropStreamTask.waitForSuccess();
    }

    public Builder builder(StreamIdentifier identifier, TableIdentifier refTable) {
        return new Builder(this.odps, identifier, refTable);
    }

    @Override
    public Iterator<Stream> iterator() {
        return this.iterator(this.getDefaultProjectName());
    }

    public Iterator<Stream> iterator(String projectName) {
        return new StreamListIterator(projectName);
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    private class StreamListIterator
    extends ListIterator<Stream> {
        private final Map<String, String> params;
        private final String projectName;
        private static final String MARKER = "marker";
        private static final String MAX_ITEMS = "maxitems";

        StreamListIterator(String projectName) {
            this.projectName = projectName;
            this.params = new HashMap<String, String>();
        }

        @Override
        protected List<Stream> list() {
            if (this.params.containsKey(MARKER) && this.params.get(MARKER).length() == 0) {
                return null;
            }
            ArrayList<Stream> streamList = new ArrayList<Stream>();
            String resource = ResourceBuilder.buildStreamObjectResource(this.projectName);
            try {
                ListStreamsResponse resp = Streams.this.client.request(ListStreamsResponse.class, resource, "GET", this.params);
                for (ListStreamsResponse.StreamObject streamName : resp.streams) {
                    streamList.add(Streams.this.get(this.projectName, streamName.name));
                }
                this.params.put(MARKER, resp.marker);
                return streamList;
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public List<Stream> list(String marker, long maxItems) {
            if (marker != null) {
                this.params.put(MARKER, marker);
            }
            if (maxItems >= 0L) {
                this.params.put(MAX_ITEMS, String.valueOf(maxItems));
            }
            return this.list();
        }

        @Override
        public String getMarker() {
            return this.params.getOrDefault(MARKER, "");
        }
    }

    @Root(name="StreamObjects", strict=false)
    private static class ListStreamsResponse {
        @ElementList(entry="StreamObject", inline=true, required=false)
        private List<StreamObject> streams = new ArrayList<StreamObject>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListStreamsResponse() {
        }

        private static class StreamObject {
            @Element(name="Name", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            private String name;

            StreamObject() {
            }

            StreamObject(String name) {
                this.name = name;
            }
        }
    }

    class Builder {
        Odps odps;
        StreamIdentifier identifier;
        TableIdentifier refTable;
        boolean ifNotExists;
        Long version;
        String timestamp;
        ReadMode readMode;
        String comment;

        Builder(Odps odps, StreamIdentifier identifier, TableIdentifier refTable) {
            this.odps = odps;
            this.identifier = identifier;
            this.refTable = refTable;
        }

        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder ifNotExists() {
            this.ifNotExists = true;
            return this;
        }

        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        public Builder withReadMode(ReadMode readMode) {
            this.readMode = readMode;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Stream build() throws OdpsException {
            Streams.this.create(this.identifier, this.refTable, this.ifNotExists, this.timestamp, this.version, this.readMode, this.comment);
            return this.odps.streams().get(this.identifier);
        }
    }

    static enum ReadMode {
        APPEND,
        CDC;

    }
}

