/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Schema;
import com.aliyun.odps.SchemaFilter;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.ExceptionUtils;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Schemas
implements Iterable<Schema> {
    private final RestClient client;
    private final Odps odps;

    Schemas(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Schema get() throws OdpsException {
        if (!StringUtils.isNullOrEmpty((String)this.odps.getCurrentSchema())) {
            throw new OdpsException("current schema not set, use Odps#setCurrentSchema(String) to set current schema");
        }
        return this.get(this.odps.getDefaultProject(), this.odps.getCurrentSchema());
    }

    public Schema get(String schemaName) {
        return this.get(this.odps.getDefaultProject(), schemaName);
    }

    public Schema get(String projectName, String schemaName) {
        ExceptionUtils.checkStringArgumentNotNull("projectName", projectName);
        ExceptionUtils.checkStringArgumentNotNull("schemaName", schemaName);
        Schema.SchemaModel model = new Schema.SchemaModel();
        model.name = schemaName;
        return new Schema(model, projectName, this.odps);
    }

    public boolean exists(String schemaName) throws OdpsException {
        return this.exists(this.odps.getDefaultProject(), schemaName);
    }

    public boolean exists(String projectName, String schemaName) throws OdpsException {
        Schema schema = this.get(projectName, schemaName);
        try {
            schema.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public void create(String schemaName) throws OdpsException {
        this.create(this.odps.getDefaultProject(), schemaName);
    }

    public void create(String projectName, String schemaName) throws OdpsException {
        this.create(projectName, schemaName, null, false);
    }

    public void create(String projectName, String schemaName, String comment, boolean ifNotExists) throws OdpsException {
        String body;
        ExceptionUtils.checkStringArgumentNotNull("projectName", projectName);
        ExceptionUtils.checkStringArgumentNotNull("schemaName", schemaName);
        Schema.SchemaModel model = new Schema.SchemaModel();
        model.project = projectName;
        model.name = schemaName;
        model.comment = comment;
        model.ifNotExists = ifNotExists;
        String resource = ResourceBuilder.buildSchemaResource(projectName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/xml");
        try {
            body = SimpleXmlUtils.marshal(model);
        }
        catch (Exception e) {
            throw new OdpsException(e);
        }
        this.client.stringRequest(resource, "POST", null, header, body);
    }

    public void delete(String schemaName) throws OdpsException {
        this.delete(this.odps.getDefaultProject(), schemaName);
    }

    public void delete(String projectName, String schemaName) throws OdpsException {
        ExceptionUtils.checkStringArgumentNotNull("projectName", projectName);
        ExceptionUtils.checkStringArgumentNotNull("schemaName", schemaName);
        String resource = ResourceBuilder.buildSchemaResource(projectName, schemaName);
        this.client.request(resource, "DELETE", null, null, null);
    }

    @Override
    public Iterator<Schema> iterator() {
        return this.iterator(this.odps.getDefaultProject());
    }

    public Iterator<Schema> iterator(String projectName) {
        return new SchemaListIterator(projectName, null);
    }

    public Iterator<Schema> iterator(String projectName, SchemaFilter filter) {
        return new SchemaListIterator(projectName, filter);
    }

    public Iterable<Schema> iterable() {
        return this.iterable(this.odps.getDefaultProject());
    }

    public Iterable<Schema> iterable(String projectName) {
        return () -> new SchemaListIterator(projectName, null);
    }

    private class SchemaListIterator
    extends ListIterator<Schema> {
        String projectName;
        Map<String, String> params = new HashMap<String, String>();
        boolean hasList = false;
        private SchemaFilter filter;

        public SchemaListIterator(String projectName, SchemaFilter filter) {
            ExceptionUtils.checkStringArgumentNotNull("projectName", projectName);
            this.projectName = projectName;
            this.filter = filter;
        }

        @Override
        public List<Schema> list(String marker, long maxItems) {
            if (marker != null) {
                this.params.put("marker", marker);
            }
            if (maxItems >= 0L) {
                this.params.put("maxitems", String.valueOf(maxItems));
            }
            return this.list();
        }

        @Override
        public String getMarker() {
            return this.params.get("marker");
        }

        @Override
        protected List<Schema> list() {
            ArrayList<Schema> schemas = new ArrayList<Schema>();
            this.params.put("expectmarker", "true");
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && StringUtils.isNullOrEmpty((String)lastMarker)) {
                return null;
            }
            if (this.filter != null) {
                if (this.filter.getName() != null) {
                    this.params.put("name", this.filter.getName());
                }
                if (this.filter.getOwner() != null) {
                    this.params.put("owner", this.filter.getOwner());
                }
            }
            String resource = ResourceBuilder.buildSchemaResource(this.projectName);
            try {
                ListSchemasResponse resp = Schemas.this.client.request(ListSchemasResponse.class, resource, "GET", this.params);
                for (Schema.SchemaModel model : resp.schemas) {
                    Schema schema = new Schema(model, this.projectName, Schemas.this.odps);
                    schemas.add(schema);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return schemas;
        }
    }

    @Root(name="Schemas", strict=false)
    static class ListSchemasResponse {
        @ElementList(entry="Schema", inline=true, required=false)
        List<Schema.SchemaModel> schemas = new ArrayList<Schema.SchemaModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String marker;
        @Element(name="MaxItems", required=false)
        Integer maxItems;

        ListSchemasResponse() {
        }
    }
}

