/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ResourceInputStream
extends InputStream {
    private Connection conn;
    private InputStream inputStream;
    private long offset = 0L;
    private final String resource;
    private final String schemaName;
    private final RestClient client;
    private boolean hasRemainingContentToFetch;
    private long chunkSize;
    private static final long MAX_SKIP_BUFFER_SIZE = 2048L;

    ResourceInputStream(RestClient client, String projectName, String schemaName, String resourceName) throws OdpsException {
        this.client = client;
        this.hasRemainingContentToFetch = false;
        this.resource = String.format("/projects/%s/resources/%s", projectName, resourceName);
        this.schemaName = schemaName;
        this.chunkSize = 0x4000000L;
        try {
            this.resetInputStream(true);
        }
        catch (Exception e) {
            throw new OdpsException(e);
        }
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        byte[] buff = new byte[1];
        int res = this.read(buff, 0, 1);
        return res == -1 ? -1 : buff[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readSize = this.inputStream.read(b, off, len);
        if (readSize == -1 && this.hasRemainingContentToFetch) {
            this.resetInputStream(false);
            readSize = this.inputStream.read(b, off, len);
        }
        if (readSize > 0) {
            this.offset += (long)readSize;
        }
        return readSize;
    }

    @Override
    public long skip(long n) throws IOException {
        int nr;
        long remaining;
        if (n <= 0L) {
            return 0L;
        }
        int size = (int)Math.min(2048L, remaining);
        byte[] skipBuffer = new byte[size];
        for (remaining = n; remaining > 0L && (nr = this.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
        }
        return n - remaining;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.inputStream.close();
        this.conn.disconnect();
    }

    private void resetInputStream(boolean init) throws IOException {
        if (!init) {
            this.close();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        try {
            HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(this.schemaName);
            params.put("rOffset", String.valueOf(this.offset));
            params.put("rSize", String.valueOf(this.chunkSize));
            this.conn = this.client.connect(this.resource, "GET", params, headers);
            Response resp = this.conn.getResponse();
            this.inputStream = this.conn.getInputStream();
            if (!resp.isOK()) {
                String message = new String(IOUtils.readFully(this.inputStream));
                this.conn.disconnect();
                throw new OdpsException(message);
            }
            String hasRemaining = resp.getHeader("x-odps-resource-has-remaining");
            this.hasRemainingContentToFetch = hasRemaining != null && hasRemaining.equalsIgnoreCase("true");
        }
        catch (OdpsException | IOException e) {
            if (this.conn != null) {
                try {
                    this.conn.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new IOException(e);
        }
    }

    protected void setChunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
    }
}

