/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.CreateProjectParam;
import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.odps.ProjectFilter;
import com.aliyun.odps.account.AccountFormat;
import com.aliyun.odps.account.BearerTokenAccount;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Projects {
    private Odps odps;
    private RestClient client;

    Projects(RestClient client) {
        this.client = client;
    }

    Projects(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Project get() throws OdpsException {
        return this.get(this.getDefaultProjectName());
    }

    public Project get(String projectName) throws OdpsException {
        Project.ProjectModel model = new Project.ProjectModel();
        model.name = projectName;
        Project prj = new Project(model, this.client);
        return prj;
    }

    public boolean exists(String projectName) throws OdpsException {
        try {
            Project project = this.get(projectName);
            project.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    public void createExternalProject(String projectName, String comment, String refProjectName, Project.ExternalProjectProperties extProperties) throws OdpsException {
        if (extProperties == null || refProjectName == null) {
            throw new OdpsException("External project must specify refProjectName and extProperties");
        }
        String resource = ResourceBuilder.buildProjectsResource();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("external_project_properties", extProperties.toJson());
        properties.put("external_project_ref_project", refProjectName);
        String xml = Projects.marshal(projectName, Project.ProjectType.external, null, null, null, comment, properties, null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(resource, "POST", null, headers, xml);
    }

    public void deleteExternalProject(String projectName) throws OdpsException {
        String resource = ResourceBuilder.buildProjectResource(projectName);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(resource, "DELETE", null, headers, "");
    }

    public void updateProject(String projectName, Map<String, String> properties) throws OdpsException {
        this.updateProject(projectName, null, null, null, properties, null);
    }

    public void updateProject(String projectName, Project.Status status, String owner, String comment, Map<String, String> properties, List<Project.Cluster> clusters) throws OdpsException {
        String resource = ResourceBuilder.buildProjectResource(projectName);
        String xml = Projects.marshal(projectName, null, owner, null, status, comment, properties, clusters);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(resource, "PUT", null, headers, xml);
    }

    public Instance delete(String projectName, boolean isImmediate) throws OdpsException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (isImmediate) {
            params.put("permanent", "true");
        }
        Response response = this.client.request(ResourceBuilder.buildProjectResource(projectName), "DELETE", params, null, null);
        if (isImmediate && response.getStatus() == 202) {
            String location = response.getHeaders().get("Location");
            if (StringUtils.isNullOrEmpty((String)location)) {
                throw new OdpsException("Invalid response, instance location required when delete project immediately.");
            }
            String token = response.getHeaders().get("x-odps-instance-token");
            if (StringUtils.isNullOrEmpty((String)token)) {
                throw new OdpsException("Invalid response, instance token required when delete project immediately.");
            }
            String instanceId = location.substring(location.lastIndexOf("/") + 1);
            BearerTokenAccount bearerAccount = new BearerTokenAccount(token);
            Odps bearerOdps = new Odps(bearerAccount);
            bearerOdps.setEndpoint(this.odps.getEndpoint());
            bearerOdps.setDefaultProject("admin_task_project");
            return bearerOdps.instances().get(instanceId);
        }
        return null;
    }

    public void create(CreateProjectParam param) throws OdpsException {
        String xml = Projects.marshal(param.getProjectModel());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        this.client.stringRequest(ResourceBuilder.buildProjectsResource(), "POST", null, headers, xml);
    }

    public Iterator<Project> iteratorByFilter(ProjectFilter filter) {
        return new ProjectListIterator(filter);
    }

    public Iterator<Project> iterator(String owner) {
        ProjectFilter filter = new ProjectFilter();
        filter.setOwner(owner);
        return new ProjectListIterator(filter);
    }

    public Iterable<Project> iterable(final String owner) {
        return new Iterable<Project>(){

            @Override
            public Iterator<Project> iterator() {
                ProjectFilter filter = new ProjectFilter();
                filter.setOwner(owner);
                return new ProjectListIterator(filter);
            }
        };
    }

    private static String marshal(Project.ProjectModel model) throws OdpsException {
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(model);
        }
        catch (Exception e) {
            throw new OdpsException("Marshal project model failed", e);
        }
        return xml;
    }

    private static String marshal(String projectName, Project.ProjectType projectType, String projectOwner, String groupName, Project.Status status, String comment, Map<String, String> properties, List<Project.Cluster> clusters) throws OdpsException {
        Project.ProjectModel model = new Project.ProjectModel();
        model.name = projectName;
        if (projectType != null) {
            model.type = projectType.toString().toLowerCase();
        }
        model.owner = projectOwner != null ? projectOwner.trim() : null;
        if (status != null) {
            model.state = status.toString().toUpperCase();
        }
        if (comment != null) {
            model.comment = comment;
        }
        model.projectGroupName = groupName;
        if (properties != null) {
            model.properties = new LinkedHashMap<String, String>(properties);
        }
        if (clusters != null) {
            model.clusters = new Project.Clusters();
            model.clusters.entries = clusters;
        }
        return Projects.marshal(model);
    }

    private class ProjectListIterator
    extends ListIterator<Project> {
        Map<String, String> params = new HashMap<String, String>();
        private ProjectFilter filter;

        ProjectListIterator(ProjectFilter filter) {
            this.filter = filter;
        }

        @Override
        public List<Project> list(String marker, long maxItems) {
            if (marker != null) {
                this.params.put("marker", marker);
            }
            if (maxItems >= 0L) {
                this.params.put("maxitems", String.valueOf(maxItems));
            }
            return this.list();
        }

        @Override
        public String getMarker() {
            return this.params.get("marker");
        }

        @Override
        protected List<Project> list() {
            try {
                ArrayList<Project> projects = new ArrayList<Project>();
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                if (this.filter != null) {
                    this.filter.addTo(this.params);
                }
                AccountFormat.setParam(Projects.this.odps.getAccountFormat(), this.params);
                ListProjectResponse resp = Projects.this.client.request(ListProjectResponse.class, ResourceBuilder.buildProjectsResource(), "GET", this.params);
                for (Project.ProjectModel model : resp.projects) {
                    Project t = new Project(model, Projects.this.client);
                    projects.add(t);
                }
                this.params.put("marker", resp.marker);
                return projects;
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Root(name="Projects", strict=false)
    static class ListProjectResponse {
        @ElementList(entry="Project", inline=true, required=false)
        List<Project.ProjectModel> projects = new LinkedList<Project.ProjectModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String marker;
        @Element(name="MaxItems", required=false)
        int maxItems;

        ListProjectResponse() {
        }
    }
}

