/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.util.fs;

import com.aliyun.odps.io.SinkOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class LocalOutputStream
extends SinkOutputStream {
    private FileOutputStream fileOutputStream;
    private long bytesWritten;
    private boolean finalized;

    public LocalOutputStream(File file) throws IOException {
        file.createNewFile();
        this.fileOutputStream = new FileOutputStream(file);
        this.bytesWritten = 0L;
        this.finalized = false;
        System.out.println("Output file created at " + file.getPath());
    }

    public void write(byte[] b) throws IOException {
        this.fileOutputStream.write(b);
        this.bytesWritten += (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fileOutputStream.write(b, off, len);
        this.bytesWritten += (long)len;
    }

    public void write(int b) throws IOException {
        this.fileOutputStream.write(b);
        ++this.bytesWritten;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void finalize() throws IOException {
        if (!this.finalized) {
            this.fileOutputStream.flush();
            this.fileOutputStream.close();
            this.finalized = true;
        }
    }
}

