/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local.runner;

import com.aliyun.odps.Odps;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.io.InputStreamSet;
import com.aliyun.odps.udf.DataAttributes;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.Extractor;
import com.aliyun.odps.udf.local.LocalRunException;
import com.aliyun.odps.udf.local.runner.BaseRunner;
import com.aliyun.odps.udf.local.runner.ExtendedRunner;
import com.aliyun.odps.udf.local.util.LocalDataAttributes;
import com.aliyun.odps.udf.local.util.fs.LocalInputStreamSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class ExtractorRunner
extends ExtendedRunner {
    private Extractor extractor;
    private boolean extractorSetup;
    private LocalDataAttributes attributes;

    public ExtractorRunner(Odps odps, Extractor extractor, DataAttributes localAttributes) {
        super(odps);
        if (extractor == null) {
            throw new IllegalArgumentException("Missing arguments:extractor");
        }
        this.extractor = extractor;
        if (!(localAttributes instanceof LocalDataAttributes)) {
            throw new UnsupportedOperationException("only accepts LocalDataAttributes.");
        }
        this.attributes = (LocalDataAttributes)localAttributes;
        this.files = new ArrayList();
        this.extractorSetup = false;
    }

    @Override
    public List<Record> yieldRecords() throws LocalRunException {
        try {
            Record record;
            if (!this.extractorSetup) {
                this.extractor.setup((ExecutionContext)this.context, (InputStreamSet)new LocalInputStreamSet(this.files), (DataAttributes)this.attributes);
                this.extractorSetup = true;
            }
            ArrayList<Record> records = new ArrayList<Record>();
            while ((record = this.extractor.extract()) != null) {
                records.add(record.clone());
            }
            this.extractor.close();
            this.extractor = null;
            return records;
        }
        catch (IOException e) {
            throw new LocalRunException(e);
        }
    }

    @Override
    public void feedFiles(List<String> paths) throws LocalRunException {
        for (String path : paths) {
            File inputLocation = new File(path);
            if (!inputLocation.exists()) {
                throw new UnsupportedOperationException(inputLocation.getAbsolutePath() + " does not exist.");
            }
            if (inputLocation.isFile()) {
                this.files.add(inputLocation);
                continue;
            }
            if (inputLocation.isDirectory()) {
                Collection filesCollection = FileUtils.listFiles((File)inputLocation, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                Object[] directoryFiles = filesCollection.toArray(new File[filesCollection.size()]);
                Arrays.sort(directoryFiles);
                this.files.addAll(Arrays.asList(directoryFiles));
                continue;
            }
            throw new UnsupportedOperationException(inputLocation + "refers to unknown file type - this should not happen");
        }
    }

    @Override
    public void feedDirectory(String directory) throws LocalRunException {
        this.feedFiles(Arrays.asList(directory));
    }

    @Override
    protected List<Object[]> internalYield() throws LocalRunException {
        List<Record> records = this.yieldRecords();
        for (Record record : records) {
            this.buffer.add(record.toArray());
        }
        return this.buffer;
    }

    @Override
    protected BaseRunner internalFeed(Object[] input) throws LocalRunException {
        ArrayList<String> paths = new ArrayList<String>(input.length);
        for (int i = 0; i < input.length; ++i) {
            if (!(input[i] instanceof String)) {
                throw new UnsupportedOperationException("must feed file path as String to ExtractorRunner");
            }
            paths.add((String)input[i]);
        }
        this.feedFiles(paths);
        return this;
    }

    @Override
    public BaseRunner feedAll(Object[][] inputs) throws LocalRunException {
        throw new UnsupportedOperationException("feedAll not supported for ExtractorRunner all input must be added through feedDirectory(), feedFiles(), or feed()");
    }

    @Override
    public BaseRunner feedAll(List<Object[]> inputs) throws LocalRunException {
        throw new UnsupportedOperationException("feedAll not supported for ExtractorRunner all input must be added through feedDirectory(), feedFiles(), or feed()");
    }
}

