/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.local;

import com.aliyun.odps.Odps;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.utils.LocalRunUtils;
import com.aliyun.odps.local.common.utils.PartitionUtils;
import com.aliyun.odps.local.common.utils.SchemaUtils;
import com.aliyun.odps.udf.UDFException;
import com.aliyun.odps.udf.local.LocalRunError;
import com.aliyun.odps.udf.local.LocalRunException;
import com.aliyun.odps.udf.local.datasource.InputSource;
import com.aliyun.odps.udf.local.datasource.TableInputSource;
import com.aliyun.odps.udf.local.runner.BaseRunner;
import com.aliyun.odps.udf.local.runner.RunnerFactory;
import com.aliyun.odps.utils.StringUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Main {
    private Options options = new Options();

    public Main() {
        this.options.addOption("c", "classname", true, "UDF,UDTF or UDAF class name");
        this.options.addOption("i", "input", true, "input table: table.p(p1=1,p2=2).c(c1,c2)");
        this.options.addOption("p", "project", true, "Default project name");
        this.options.addOption(null, "endpoint", true, "Specify the endpoint");
        this.options.addOption(null, "access-id", true, "The accessId of ALIYUN account");
        this.options.addOption(null, "access-key", true, "The accessKey of ALIYUN account");
        this.options.addOption(null, "tunnel-endpoint", true, "Specify the customer tunnel endpoint");
        this.options.addOption("w", "warehouse-dir", true, "Warehouse Dir");
        this.options.addOption(null, "record-limit", true, "download record num limit");
        this.options.addOption(null, "column-separator", true, "column separator for data input");
        this.options.addOption("h", "help", false, "print this help information");
    }

    public static void main(String[] args) throws ParseException, LocalRunException, UDFException, IOException {
        Main driver = new Main();
        driver.run(args);
    }

    public void run(String[] args) throws LocalRunException {
        try {
            Object[] data;
            PosixParser parser = new PosixParser();
            CommandLine cmdl = parser.parse(this.options, args);
            this.validArgments(cmdl);
            String defaultProject = cmdl.getOptionValue("project");
            String endpoint = cmdl.getOptionValue("endpoint");
            String accessId = cmdl.getOptionValue("access-id");
            String accessKey = cmdl.getOptionValue("access-key");
            AliyunAccount account = new AliyunAccount(accessId, accessKey);
            Odps odps = new Odps((Account)account);
            odps.setEndpoint(endpoint);
            odps.setDefaultProject(defaultProject);
            String warehouseDir = cmdl.getOptionValue("w");
            if (StringUtils.isNotBlank((String)warehouseDir)) {
                WareHouse.getInstance((String)warehouseDir);
            }
            this.setTunnelEndpoint(cmdl.getOptionValue("tunnel-endpoint"));
            WareHouse.getInstance().setRecordLimit(cmdl.getOptionValue("record-limit"));
            WareHouse.getInstance().setColumnSeparator(cmdl.getOptionValue("column-separator"));
            TableInfo tableInfo = this.getTableInfo(cmdl);
            BaseRunner runner = RunnerFactory.getRunner(cmdl, odps, tableInfo);
            TableInputSource inputSource = new TableInputSource(tableInfo);
            while ((data = ((InputSource)inputSource).getNextRow()) != null) {
                runner.feed(data);
            }
            List<Object[]> result = runner.yield();
            for (Object[] record : result) {
                System.out.println(StringUtils.join((Object[])record, (String)","));
            }
        }
        catch (ParseException e) {
            throw new LocalRunException(e);
        }
        catch (LocalRunException e) {
            throw e;
        }
        catch (UDFException e) {
            throw new LocalRunException(e);
        }
        catch (IOException e) {
            throw new LocalRunException(e);
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    private void validArgments(CommandLine cmdl) {
        if (cmdl.hasOption("h")) {
            this.printHelpAndExit(0);
        }
        if (!cmdl.hasOption("c")) {
            System.err.println("missing argument '-c'");
            this.printHelpAndExit(1);
        }
        if (!cmdl.hasOption("i")) {
            System.err.println("missing argument '-i'");
            this.printHelpAndExit(1);
        }
    }

    private TableInfo getTableInfo(CommandLine cmdl) {
        String inputArgs = cmdl.getOptionValue("i");
        String[] ss = inputArgs.split("\\.");
        if (ss == null || ss.length == 0) {
            throw new LocalRunError("Input table can't null ");
        }
        String table = ss[0].trim();
        String[] partitions = null;
        String[] columns = null;
        for (int i = 1; i < ss.length; ++i) {
            String str = ss[i].trim();
            if (str.startsWith("p(")) {
                if (str.length() < 6) {
                    throw new LocalRunError("Invalid partitions ");
                }
                str = str.substring(2, str.length() - 1);
                partitions = str.split(",");
                for (int j = 0; j < partitions.length; ++j) {
                    if (partitions[j].split("=").length == 2) continue;
                    throw new LocalRunError("Invalid partitions:" + str);
                }
                continue;
            }
            if (str.startsWith("c(")) {
                if (str.length() < 4) {
                    throw new LocalRunError("Invalid columns");
                }
                str = str.substring(2, str.length() - 1);
                columns = SchemaUtils.splitColumn((String)str);
                continue;
            }
            throw new LocalRunError("Invalid input table info, please check it");
        }
        return TableInfo.builder().projectName(cmdl.getOptionValue("project")).tableName(table).partSpec(PartitionUtils.convert(partitions)).cols(columns).build();
    }

    private void printHelpAndExit(int exitCode) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("judt", this.options);
        System.exit(exitCode);
    }

    public void setTunnelEndpoint(String tunnelEndpoint) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)tunnelEndpoint)) {
            return;
        }
        if (!LocalRunUtils.validateTunnelEndpoint((String)tunnelEndpoint)) {
            throw new IllegalArgumentException("Invalid tunnel endpoint: " + tunnelEndpoint);
        }
        WareHouse.getInstance().setTunnelEndpoint(tunnelEndpoint);
    }
}

