/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.graph.JobConf;
import com.aliyun.odps.graph.job.JobRunner;
import com.aliyun.odps.mapred.RunningJob;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.utils.ReflectionUtils;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GraphJob
extends JobConf {
    private static final Log LOG = LogFactory.getLog(GraphJob.class);
    private RunningJob rJob = null;
    private RunningJob rJobShadow = null;
    private JsonObject cupidProp;
    private JsonObject gsProp;
    private JsonObject userSetting;

    public GraphJob() {
    }

    @Deprecated
    public GraphJob(boolean loadDefaults) {
        super(loadDefaults);
    }

    @Deprecated
    public GraphJob(Configuration conf, JobConf.JobState js) {
        super(conf, js);
    }

    public GraphJob(Configuration conf) {
        super(conf);
    }

    @Deprecated
    public GraphJob(String config) {
        super(config);
    }

    public boolean isComplete() throws IOException {
        this.ensureState(JobConf.JobState.RUNNING);
        return this.rJob.isComplete();
    }

    public boolean isSuccessful() throws IOException {
        this.ensureState(JobConf.JobState.RUNNING);
        return this.rJob.isSuccessful();
    }

    public void killJob() throws IOException {
        this.ensureState(JobConf.JobState.RUNNING);
        this.rJob.killJob();
    }

    public void submit() throws IOException {
        this.ensureState(JobConf.JobState.DEFINE);
        try {
            this.parseArgs();
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new IOException(e.getMessage());
        }
        try {
            this.submitOdpsGraphJob();
        }
        catch (OdpsException oe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)oe));
            throw new IOException(oe.getMessage());
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new IOException(e.getMessage());
        }
        this.state = JobConf.JobState.RUNNING;
    }

    public void run() throws IOException {
        if (this.state == JobConf.JobState.DEFINE) {
            this.submit();
        }
        this.rJob.waitForCompletion();
        if (!this.rJob.isSuccessful()) {
            throw new IOException("Job failed!");
        }
    }

    public Counters getCounters() throws IOException {
        return this.rJob.getCounters();
    }

    private void submitOdpsGraphJob() throws Exception {
        String runner = "com.aliyun.odps.graph.job.NetworkJobRunner";
        if (SessionState.get().isLocalRun()) {
            runner = "com.aliyun.odps.graph.local.LocalGraphJobRunner";
        }
        JobRunner jobrunner = null;
        try {
            Class<?> clz = Class.forName(runner);
            jobrunner = (JobRunner)ReflectionUtils.newInstance(clz, (Configuration)this);
        }
        catch (ClassNotFoundException e) {
            LOG.fatal((Object)"Internal error: currupted installation.", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.rJob = jobrunner.submit();
    }

    private void parseArgs() {
        String resources;
        Properties prop = System.getProperties();
        String runmode = prop.getProperty("odps.runner.mode");
        if (runmode != null && runmode.length() != 0) {
            SessionState.get().setLocalRun(runmode.equalsIgnoreCase("local"));
        }
        if ((resources = prop.getProperty("odps.cache.resources")) != null && !resources.trim().isEmpty()) {
            this.addCacheResourcesToClassPath(resources);
        }
        String project = prop.getProperty("odps.project.name");
        if (prop.getProperty("odps.access.id") != null) {
            String logViewHost;
            String endpoint = prop.getProperty("odps.end.point");
            String accessId = prop.getProperty("odps.access.id");
            String accessKey = prop.getProperty("odps.access.key");
            AliyunAccount account = new AliyunAccount(accessId, accessKey);
            Odps odps = new Odps((Account)account);
            odps.setDefaultProject(project);
            if (endpoint != null && endpoint.length() != 0) {
                odps.setEndpoint(endpoint);
            }
            if ((logViewHost = prop.getProperty("odps.logview.host")) != null && logViewHost.length() != 0) {
                odps.setLogViewHost(logViewHost);
            }
            String runningCluster = SessionState.get().getOdps().instances().getDefaultRunningCluster();
            odps.instances().setDefaultRunningCluster(runningCluster);
            SessionState.get().setOdps(odps);
        } else if (SessionState.get().isLocalRun() && SessionState.get().getOdps() == null) {
            AliyunAccount account = new AliyunAccount("defaultId", "defaultKey");
            Odps odps = new Odps((Account)account);
            odps.setDefaultProject(project);
            SessionState.get().setOdps(odps);
        }
    }
}

