/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.local.common.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.AnyTypeInfo;
import com.aliyun.odps.local.common.ColumnOrConstant;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.local.common.utils.TypeConvertUtils;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoParser;
import com.aliyun.odps.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchemaUtils {
    private static final Log LOG = LogFactory.getLog(SchemaUtils.class);
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String NAME_TYPE_DELIMITER = ":";
    private static final String COLUMN_SEPARATOR = ",";
    private static final String RESOLVE_SEPARATOR = ",";
    private static final String CONSTANT_TYPE_DELIMITER = "\\|";

    public static boolean existsSchemaFile(File dir) {
        return new File(dir, "__schema__").exists();
    }

    public static void generateSchemaFile(TableMeta table, List<Integer> indexes, File dir) {
        if (table == null || dir == null) {
            throw new IllegalArgumentException("Missing arguments: table|dir");
        }
        if (StringUtils.isBlank((String)table.getProjName()) || StringUtils.isBlank((String)table.getTableName())) {
            throw new IllegalArgumentException("Project|table is empty when table.getProjName()|table.getTableName()");
        }
        TableInfo tableInfo = TableInfo.builder().projectName(table.getProjName()).tableName(table.getTableName()).build();
        LOG.info((Object)("Start to write table scheme : " + tableInfo + "-->" + dir.getAbsolutePath()));
        StringBuffer sb = new StringBuffer();
        sb.append("project=" + table.getProjName());
        sb.append("\n");
        sb.append("table=" + table.getTableName());
        sb.append("\n");
        StringBuffer sb1 = new StringBuffer();
        Column[] columns = table.getCols();
        int length = indexes == null ? table.getCols().length : indexes.size();
        for (int i = 0; i < length; ++i) {
            int index = indexes == null ? i : indexes.get(i);
            Column col = columns[index];
            if (sb1.length() > 0) {
                sb1.append(",");
            }
            sb1.append(col.getName() + NAME_TYPE_DELIMITER + col.getTypeInfo().toString());
        }
        sb.append("columns=" + sb1.toString());
        sb.append("\n");
        Column[] partitions = table.getPartitions();
        if (partitions != null && partitions.length > 0) {
            sb.append("partitions=" + SchemaUtils.toString(partitions));
            sb.append("\n");
        }
        dir.mkdirs();
        File schemaFile = new File(dir, "__schema__");
        LOG.info((Object)("generate schema file: " + schemaFile.getAbsolutePath()));
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(schemaFile);
            String result = sb.toString();
            result = result.substring(0, result.length() - 1);
            ((OutputStream)out).write(result.getBytes("utf-8"));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        LOG.info((Object)("Finished to write table scheme : " + tableInfo + "-->" + dir.getAbsolutePath()));
    }

    public static TableMeta readSchema(File dir) {
        if (dir == null || !dir.exists()) {
            return null;
        }
        File schemaFile = new File(dir, "__schema__");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(schemaFile)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("__schema__ file not exists in direcotry " + dir.getAbsolutePath());
        }
        String line = null;
        try {
            line = br.readLine();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        String project = null;
        String table = null;
        Column[] cols = null;
        Column[] partitionCols = null;
        while (line != null) {
            String partitions;
            if ((line = line.trim()).equals("") || line.startsWith("#")) {
                try {
                    line = br.readLine();
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            String[] kv = line.split(KEY_VALUE_SEPARATOR);
            if (kv == null || kv.length != 2 || kv[0] == null || kv[0].trim().isEmpty() || kv[1] == null || kv[1].trim().isEmpty()) {
                try {
                    line = br.readLine();
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            kv[0] = kv[0].trim();
            kv[1] = kv[1].trim();
            if (kv[0].equals("project")) {
                project = kv[1];
            } else if (kv[0].equals("table")) {
                table = kv[1];
                if (table == null || table.trim().isEmpty()) {
                    throw new RuntimeException("Table schema file '_schema_' must include 'table'");
                }
            } else if (kv[0].equals("columns")) {
                String columns = kv[1];
                if (columns == null || columns.trim().isEmpty()) {
                    throw new RuntimeException("Table schema file '_schema_' must include 'columns'");
                }
                cols = SchemaUtils.fromString(columns);
                if (cols.length == 0) {
                    throw new RuntimeException("'columns' in table schema file '_schema_' has invalid value");
                }
            } else if (kv[0].equals("partitions") && (partitions = kv[1]) != null && !partitions.trim().isEmpty()) {
                partitionCols = SchemaUtils.fromString(partitions);
            }
            try {
                line = br.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            br.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new TableMeta(project, table, cols, partitionCols);
    }

    public static String[] getColumnNames(Column[] cols) {
        String[] names = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            names[i] = cols[i].getName();
        }
        return names;
    }

    public static String toString(Column[] cols) {
        if (cols == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Column c : cols) {
            if (c == null) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(c.getName()).append(NAME_TYPE_DELIMITER).append(c.getTypeInfo().toString());
        }
        return sb.toString();
    }

    public static Column[] fromString(String str) {
        ArrayList<Column> colList = new ArrayList<Column>();
        String remain = str;
        int pos = 0;
        IllegalArgumentException exception = null;
        while (remain.length() > 0) {
            String candidate;
            String[] nameType;
            if ((pos = remain.indexOf(",", pos)) < 0) {
                pos = remain.length();
            }
            if ((nameType = (candidate = remain.substring(0, pos)).split(NAME_TYPE_DELIMITER, 2)).length != 2) {
                throw new IllegalArgumentException("Malformed schema definition, expecting \"name:type\" but was \"" + nameType + "\"");
            }
            try {
                TypeInfo typeInfo = TypeInfoParser.getTypeInfoFromTypeString((String)nameType[1]);
                if (typeInfo != null) {
                    exception = null;
                    colList.add(new Column(nameType[0], typeInfo));
                    if (pos == remain.length()) {
                        remain = "";
                        continue;
                    }
                    remain = remain.substring(pos + 1);
                    pos = 0;
                    continue;
                }
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            if (pos == remain.length()) {
                remain = "";
                continue;
            }
            ++pos;
        }
        if (exception != null) {
            throw exception;
        }
        return colList.toArray(new Column[0]);
    }

    public static List<TypeInfo> parseResolveTypeInfo(String str) throws IllegalArgumentException {
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>();
        String remain = str;
        int pos = 0;
        IllegalArgumentException exception = null;
        while (remain.length() > 0) {
            if ((pos = remain.indexOf(",", pos)) < 0) {
                pos = remain.length();
            }
            String candidate = remain.substring(0, pos).trim();
            try {
                AnyTypeInfo typeInfo = "*".equals(candidate) || "ANY".equalsIgnoreCase(candidate) ? new AnyTypeInfo() : TypeInfoParser.getTypeInfoFromTypeString((String)candidate);
                if (typeInfo != null) {
                    exception = null;
                    types.add(typeInfo);
                    if (pos == remain.length()) {
                        remain = "";
                        continue;
                    }
                    remain = remain.substring(pos + 1);
                    pos = 0;
                    continue;
                }
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            if (pos == remain.length()) {
                remain = "";
                continue;
            }
            ++pos;
        }
        if (exception != null) {
            throw exception;
        }
        return types;
    }

    public static String[] splitColumn(String str) {
        ArrayList<String> colList = new ArrayList<String>();
        String remain = str;
        int pos = 0;
        while (remain.length() > 0) {
            if ((pos = remain.indexOf(",", pos)) < 0) {
                pos = remain.length();
            }
            String candidate = remain.substring(0, pos).trim();
            boolean found = true;
            if (candidate.startsWith("\"")) {
                found = SchemaUtils.isStringConstant(candidate);
            }
            if (found) {
                colList.add(candidate);
                if (pos == remain.length()) {
                    remain = "";
                    continue;
                }
                remain = remain.substring(pos + 1);
                pos = 0;
                continue;
            }
            if (pos == remain.length()) {
                remain = "";
                continue;
            }
            ++pos;
        }
        return colList.toArray(new String[0]);
    }

    public static ColumnOrConstant parseColumn(String colStr, TableMeta tableMeta) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)colStr)) {
            throw new IllegalArgumentException("column or constant is blank");
        }
        if (SchemaUtils.isStringConstant(colStr)) {
            String value = colStr.substring(1, colStr.length() - 1);
            TypeInfo typeInfo = TypeInfoParser.getTypeInfoFromTypeString((String)"string");
            return new ColumnOrConstant((Object)value, typeInfo);
        }
        String[] constantAndType = colStr.split(CONSTANT_TYPE_DELIMITER);
        if (constantAndType.length == 2) {
            String type = constantAndType[1].trim();
            TypeInfo typeInfo = TypeInfoParser.getTypeInfoFromTypeString((String)type);
            if (typeInfo == null) {
                throw new IllegalArgumentException("type " + type + " is invalid");
            }
            String constant = constantAndType[0].trim();
            Object value = TypeConvertUtils.fromString(typeInfo, constant, false);
            if (value == null) {
                throw new IllegalArgumentException("convert to constant value failed:" + colStr);
            }
            return new ColumnOrConstant(value, typeInfo);
        }
        Integer colIndex = null;
        if (tableMeta != null) {
            for (int j = 0; j < tableMeta.getCols().length; ++j) {
                if (!tableMeta.getCols()[j].getName().equals(colStr)) continue;
                colIndex = j;
                break;
            }
            if (colIndex == null) {
                throw new IllegalArgumentException("ODPS-0720021: Column does not exist - " + colStr + " in table " + tableMeta.getProjName() + "." + tableMeta.getTableName());
            }
        }
        return new ColumnOrConstant(colStr, colIndex);
    }

    public static List<ColumnOrConstant> parseColumnConstant(String[] columns, TableMeta tableMeta) throws IllegalArgumentException {
        if (columns == null || columns.length == 0) {
            return null;
        }
        ArrayList<ColumnOrConstant> columnOrConstants = new ArrayList<ColumnOrConstant>(columns.length);
        for (String column : columns) {
            columnOrConstants.add(SchemaUtils.parseColumn(column, tableMeta));
        }
        return columnOrConstants;
    }

    private static boolean isStringConstant(String str) {
        return str.length() > 2 && str.startsWith("\"") && str.endsWith("\"");
    }
}

