/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.local.common.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableResource;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.ColumnOrConstant;
import com.aliyun.odps.local.common.DownloadMode;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.utils.LocalRunUtils;
import com.aliyun.odps.local.common.utils.PartitionUtils;
import com.aliyun.odps.local.common.utils.SchemaUtils;
import com.aliyun.odps.local.common.utils.TypeConvertUtils;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.utils.StringUtils;
import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadUtils {
    private static final Log LOG = LogFactory.getLog(DownloadUtils.class);
    public static final Charset encoding = Charset.forName("UTF-8");

    public static void downloadTableSchemeAndData(Odps odps, TableInfo tableInfo, int limitDownloadRecordCount, char inputColumnSeperator) {
        if (odps == null || tableInfo == null) {
            throw new IllegalArgumentException("Missing arguments:odps|tableInfo");
        }
        if (StringUtils.isBlank((String)tableInfo.getProjectName())) {
            tableInfo.setProjectName(odps.getDefaultProject());
        }
        DownloadUtils.validateTable(odps, tableInfo);
        Table table = odps.tables().get(tableInfo.getProjectName(), tableInfo.getTableName());
        File tableDir = WareHouse.getInstance().getTableDir(tableInfo.getProjectName(), tableInfo.getTableName());
        if (!tableDir.exists()) {
            tableDir.mkdirs();
        }
        TableMeta tableMeta = TableMeta.fromTable(table);
        SchemaUtils.generateSchemaFile(tableMeta, null, tableDir);
        if (tableMeta.getPartitions() != null && tableMeta.getPartitions().length > 0) {
            LinkedHashMap parts = tableInfo.getPartSpec();
            int downloadedPartition = 0;
            for (Partition partition : table.getPartitions()) {
                PartitionSpec spec = partition.getPartitionSpec();
                if (!DownloadUtils.matches(spec, parts)) continue;
                DownloadUtils.downloadTable(odps, tableMeta, spec, limitDownloadRecordCount, inputColumnSeperator);
                ++downloadedPartition;
            }
            if (downloadedPartition == 0) {
                throw new RuntimeException("No partition found for " + tableInfo.toString());
            }
        } else {
            if (tableInfo.getPartSpec().size() > 0) {
                throw new RuntimeException("Warehouse not exists table: " + tableInfo + " ,while try to download from remote server found it is not a partitioned table");
            }
            DownloadUtils.downloadTable(odps, tableMeta, null, limitDownloadRecordCount, inputColumnSeperator);
        }
    }

    public static File downloadTable(Odps odps, TableMeta tableMeta, PartitionSpec partition, int limitDownloadRecordCount, char inputColumnSeperator) {
        TableInfo tableInfo = TableInfo.builder().projectName(tableMeta.getProjName()).tableName(tableMeta.getTableName()).partSpec(partition).build();
        List<String[]> records = DownloadUtils.downloadTableData(odps, tableMeta.getProjName(), tableMeta.getTableName(), partition, limitDownloadRecordCount, null);
        File tableDir = WareHouse.getInstance().getTableDir(tableMeta.getProjName(), tableMeta.getTableName());
        if (!tableDir.exists()) {
            tableDir.mkdirs();
        }
        File dataDir = tableDir;
        if (partition != null && !(dataDir = new File(tableDir, PartitionUtils.toString(partition))).exists()) {
            dataDir.mkdirs();
        }
        LOG.info((Object)("Start to write table: " + tableInfo.toString() + "-->" + dataDir.getAbsolutePath()));
        File dataFile = new File(dataDir, "data");
        try {
            dataFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CsvWriter writer = new CsvWriter(dataFile.getAbsolutePath(), inputColumnSeperator, encoding);
        try {
            for (String[] record : records) {
                writer.writeRecord(record);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        writer.close();
        LOG.info((Object)("Finished write table: " + tableInfo.toString() + "-->" + dataDir.getAbsolutePath()));
        return dataDir;
    }

    public static List<String[]> downloadTableData(Odps odps, String projectName, String tableName, PartitionSpec partition, int limitDownloadRecordCount, String[] readCols) {
        if (odps == null || StringUtils.isBlank((String)projectName) || StringUtils.isBlank((String)tableName)) {
            throw new IllegalArgumentException("Missing arguments: odps|projectName|tablename");
        }
        TableInfo tableInfo = TableInfo.builder().projectName(projectName).tableName(tableName).partSpec(partition).build();
        DownloadUtils.validateTable(odps, tableInfo);
        LOG.info((Object)("Start to download table: '" + tableInfo.toString() + "', download mode:" + (Object)((Object)WareHouse.getInstance().getDownloadMode())));
        LinkedList<String[]> list = new LinkedList<String[]>();
        Table table = odps.tables().get(projectName, tableName);
        TableMeta tableMeta = TableMeta.fromTable(table);
        TableTunnel tunnel = new TableTunnel(odps);
        String tunnelEndpoint = WareHouse.getInstance().getTunnelEndpoint();
        try {
            if (StringUtils.isNotBlank((String)tunnelEndpoint)) {
                tunnel.setEndpoint(tunnelEndpoint);
            }
            TableTunnel.DownloadSession downloadSession = partition == null ? tunnel.createDownloadSession(projectName, tableName) : tunnel.createDownloadSession(projectName, tableName, partition);
            LOG.info((Object)("Tunnel DownloadSession ID is : " + downloadSession.getId()));
            TunnelRecordReader reader = downloadSession.openRecordReader(0L, (long)limitDownloadRecordCount);
            Record record = null;
            int columnCount = tableMeta.getCols().length;
            while ((record = reader.read()) != null) {
                String[] vals = new String[columnCount];
                for (int i = 0; i < vals.length; ++i) {
                    vals[i] = DownloadUtils.getColumnValueString(tableMeta, record, i);
                }
                list.add(vals);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(LocalRunUtils.getDownloadErrorMsg(tableInfo.toString()) + e.getMessage());
        }
        if (readCols == null) {
            return list;
        }
        List<ColumnOrConstant> columnOrConstants = SchemaUtils.parseColumnConstant(readCols, tableMeta);
        int indexLength = columnOrConstants.size();
        LinkedList<String[]> result = new LinkedList<String[]>();
        for (String[] srcData : list) {
            String[] dstData = new String[indexLength];
            for (int i = 0; i < indexLength; ++i) {
                ColumnOrConstant columnOrConstant = columnOrConstants.get(i);
                dstData[i] = columnOrConstant.isConstant() ? TypeConvertUtils.toString(columnOrConstant.getConstantValue(), columnOrConstant.getConstantTypeInfo()) : srcData[columnOrConstant.getColIndex()];
                result.add(dstData);
            }
        }
        LOG.info((Object)("Finished download table: '" + tableInfo.toString() + "', download mode:" + (Object)((Object)WareHouse.getInstance().getDownloadMode())));
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void downloadResource(Odps odps, String projName, String resourceName, int limitDownloadRecordCount, char inputColumnSeperator) {
        if (odps == null) throw new IllegalArgumentException("Missing arguments: odps|projName|resourceName");
        if (StringUtils.isBlank((String)projName) != false) throw new IllegalArgumentException("Missing arguments: odps|projName|resourceName");
        if (StringUtils.isBlank((String)resourceName)) {
            throw new IllegalArgumentException("Missing arguments: odps|projName|resourceName");
        }
        if (WareHouse.getInstance().getDownloadMode() == DownloadMode.NEVER) {
            throw new RuntimeException("Download resource '" + projName + "." + resourceName + "' Failed! Current download mode is:" + (Object)DownloadMode.NEVER + ".Please check parameter'" + "odps.mapred.local.download.mode" + "'");
        }
        try {
            if (!odps.resources().exists(projName, resourceName)) {
                throw new RuntimeException("Download resource: " + projName + "." + resourceName + " Failed!Remote resource not found! Download mode:" + (Object)WareHouse.getInstance().getDownloadMode());
            }
        }
        catch (OdpsException e1) {
            throw new RuntimeException(e1);
        }
        resource = odps.resources().get(projName, resourceName);
        resFile = WareHouse.getInstance().getReourceFile(projName, resourceName);
        DownloadUtils.LOG.info((Object)("Start to download resource: " + resource.getName() + "-->" + resFile.getAbsolutePath() + ", type: " + resource.getType() + ",download mode:" + (Object)WareHouse.getInstance().getDownloadMode()));
        switch (1.$SwitchMap$com$aliyun$odps$Resource$Type[resource.getType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                in = null;
                out = null;
                try {
                    in = odps.resources().getResourceAsStream(resource.getProject(), resource.getName());
                    resFile.getParentFile().mkdirs();
                    out = new FileOutputStream(resFile);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    if (in != null) {
                    }
                    ** GOTO lbl53
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                        catch (OdpsException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Throwable var10_15) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (out == null) throw var10_15;
                        try {
                            out.close();
                            throw var10_15;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
lbl53:
                // 2 sources

                if (out == null) break;
                try {
                    out.close();
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case 5: {
                tr = new TableResource(resource);
                stable = tr.getSourceTable();
                sourceProjName = stable.getProject();
                sourceTbleName = stable.getName();
                partSpec = tr.getSourceTablePartition();
                tableInfo = null;
                if (partSpec == null) {
                    tableInfo = TableInfo.builder().projectName(sourceProjName).tableName(sourceTbleName).build();
                    if (!WareHouse.getInstance().existsTable(sourceProjName, sourceTbleName)) {
                        DownloadUtils.downloadTableSchemeAndData(odps, tableInfo, limitDownloadRecordCount, inputColumnSeperator);
                    }
                } else {
                    partMap = PartitionUtils.convert(partSpec);
                    tableInfo = TableInfo.builder().projectName(sourceProjName).tableName(sourceTbleName).partSpec(partMap).build();
                    if (!WareHouse.getInstance().existsPartition(sourceProjName, sourceTbleName, partSpec)) {
                        DownloadUtils.downloadTableSchemeAndData(odps, tableInfo, limitDownloadRecordCount, inputColumnSeperator);
                    }
                }
                WareHouse.getInstance().createTableReourceFile(resource.getProject(), resource.getName(), tableInfo);
                break;
            }
        }
        DownloadUtils.LOG.info((Object)("Finished download resource: " + resource.getName() + "-->" + resFile.getAbsolutePath() + ", type: " + resource.getType() + ",download mode:" + (Object)WareHouse.getInstance().getDownloadMode()));
    }

    public static TableMeta downloadTableInfo(Odps odps, TableInfo tableInfo) {
        DownloadUtils.validateTable(odps, tableInfo);
        Table table = odps.tables().get(tableInfo.getProjectName(), tableInfo.getTableName());
        return TableMeta.fromTable(table);
    }

    private static String getColumnValueString(TableMeta tableMeta, Record record, int colIndex) {
        Column col = tableMeta.getCols()[colIndex];
        return TypeConvertUtils.toString(record.get(colIndex), col.getTypeInfo());
    }

    private static boolean matches(PartitionSpec spec, Map<String, String> parts) {
        for (Map.Entry<String, String> e : parts.entrySet()) {
            if (spec.get(e.getKey()).equals(e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void validateTable(Odps odps, TableInfo tableInfo) {
        if (tableInfo == null) {
            throw new IllegalArgumentException("Missing arugument: tableInfo");
        }
        if (WareHouse.getInstance().getDownloadMode() == DownloadMode.NEVER) {
            throw new RuntimeException("Download table schema '" + tableInfo.toString() + "' Failed! Current download mode is:" + (Object)((Object)DownloadMode.NEVER) + ".Please check parameter '" + "odps.mapred.local.download.mode" + "'");
        }
        try {
            if (!odps.tables().exists(tableInfo.getProjectName(), tableInfo.getTableName())) {
                throw new RuntimeException("Download table " + tableInfo + " Failed! Remote table not found!Download mode:" + (Object)((Object)WareHouse.getInstance().getDownloadMode()));
            }
        }
        catch (OdpsException e1) {
            throw new RuntimeException(e1);
        }
        Table table = odps.tables().get(tableInfo.getProjectName(), tableInfo.getTableName());
        if (tableInfo.getPartitionSpec() != null && !tableInfo.getPartitionSpec().isEmpty() && (table.getSchema().getPartitionColumns() == null || table.getSchema().getPartitionColumns().isEmpty())) {
            throw new RuntimeException("Download table " + tableInfo + "Failed! Remote table " + table.getProject() + "." + table.getName() + " is not a partitioned table,Download mode:" + (Object)((Object)WareHouse.getInstance().getDownloadMode()));
        }
        if (table.isVirtualView()) {
            throw new RuntimeException("ODPS-0720101: Input table should not be a view - " + tableInfo);
        }
    }

    public static CsvReader newCsvReader(String fileName, char sep, Charset charset) throws FileNotFoundException {
        CsvReader reader = new CsvReader(fileName, sep, charset);
        reader.setSafetySwitch(false);
        return reader;
    }
}

