/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.cli;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.conf.Configuration;

public class OdpsConf
extends Configuration {
    private static final String PROJNAME = "odps.project.name";
    private static final String ENDPOINT = "odps.end.point";
    private static final String ACCESSID = "odps.access.id";
    private static final String STS_TOKEN = "odps.sts.token";
    private static final String ACCESSKEY = "odps.access.key";
    private static final String APP_ACCESS_ID = "odps.app.access.id";
    private static final String APP_ACCESS_KEY = "odps.app.access.key";
    private static final String ACCOUNT_PROVIDER = "odps.account.provider";
    private static final String PROXYHOST = "odps.proxy.host";
    private static final String PROXYPORT = "odps.proxy.port";
    private static final String RUNMODE = "odps.runner.mode";

    public String getProjName() {
        return this.get(PROJNAME);
    }

    public void setProjName(String projName) {
        this.set(PROJNAME, projName);
    }

    public String getEndpoint() {
        return this.get(ENDPOINT);
    }

    public void setEndpoint(String endpoint) {
        this.set(ENDPOINT, endpoint);
    }

    public String getAccessId() {
        return this.get(ACCESSID);
    }

    public void setAccessId(String accessId) {
        this.set(ACCESSID, accessId);
    }

    public String getAccessKey() {
        return this.get(ACCESSKEY);
    }

    public void setAccessKey(String accessKey) {
        this.set(ACCESSKEY, accessKey);
    }

    public String getAppAccessId() {
        return this.get(APP_ACCESS_ID);
    }

    public void setAppAccessId(String appAccessId) {
        this.set(APP_ACCESS_ID, appAccessId);
    }

    public String getAppAccessKey() {
        return this.get(APP_ACCESS_KEY);
    }

    public void setAppAccessKey(String appAccessKey) {
        this.set(APP_ACCESS_KEY, appAccessKey);
    }

    public String getStsToken() {
        return this.get(STS_TOKEN);
    }

    public void setStsToken(String stsToken) {
        this.set(STS_TOKEN, stsToken);
    }

    public String getProxyHost() {
        return this.get(PROXYHOST);
    }

    public void setProxyHost(String host) {
        this.set(PROXYHOST, host);
    }

    public String getRunMode() {
        return this.get(RUNMODE, "remote");
    }

    public void setRunMode(String mode) {
        this.set(RUNMODE, mode);
    }

    public String getProxyPort() {
        return this.get(PROXYPORT);
    }

    public void setProxyPort(String port) {
        this.set(PROXYPORT, port);
    }

    public Account.AccountProvider getAccountProvider() throws OdpsException {
        String provider = this.get(ACCOUNT_PROVIDER);
        Account.AccountProvider result = Account.AccountProvider.ALIYUN;
        if (provider != null) {
            provider = provider.trim().toUpperCase();
            try {
                result = Account.AccountProvider.valueOf((String)provider);
            }
            catch (Exception exception) {
                throw new OdpsException("Unsupported account provider:" + provider);
            }
        }
        return result;
    }

    static {
        Configuration.addDefaultResource((String)"odps-conf.xml");
    }
}

