/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.cli;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.mapred.cli.OptionParser;
import com.aliyun.odps.mapred.conf.SessionState;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.cli.ParseException;

public class Cli {
    public static void main(String[] args) {
        SessionState ss = SessionState.get();
        OptionParser parser = new OptionParser(ss);
        try {
            parser.parse(args);
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class not found:" + e.getMessage());
            System.exit(-1);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            parser.usage();
            System.exit(-1);
        }
        catch (OdpsException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        try {
            Method main = parser.getMainClass().getMethod("main", String[].class);
            main.invoke(null, new Object[]{parser.getArguments()});
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof OdpsException) {
                OdpsException ex = (OdpsException)t;
                System.err.println(ex.getErrorCode() + ":" + ex.getMessage());
                System.exit(-1);
            }
            throw new RuntimeException("Unknown error", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

