/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.type;

import com.aliyun.odps.Column;
import com.aliyun.odps.mapred.bridge.type.NaturalRecordComparator;
import com.aliyun.odps.mapred.conf.JobConf;
import java.util.HashMap;

public class ColumnBasedRecordComparator
extends NaturalRecordComparator {
    int[] selIdxs;
    JobConf.SortOrder[] sortOrders;

    public ColumnBasedRecordComparator(int[] selIdxs, Column[] schema) {
        super(schema);
        this.selIdxs = selIdxs;
        this.sortOrders = null;
    }

    public ColumnBasedRecordComparator(String[] selCols, Column[] schema) {
        this(selCols, schema, null);
    }

    public ColumnBasedRecordComparator(String[] selCols, Column[] schema, JobConf.SortOrder[] sortOrders) {
        super(schema);
        if (sortOrders != null && selCols.length != sortOrders.length) {
            throw new IllegalArgumentException("Number of sort column is not equal to length of sort order array.");
        }
        this.sortOrders = sortOrders;
        this.selIdxs = new int[selCols.length];
        HashMap<String, Integer> reverseLookupMap = new HashMap<String, Integer>();
        int i = 0;
        for (Column column : schema) {
            reverseLookupMap.put(column.getName(), i);
            ++i;
        }
        i = 0;
        for (String string : selCols) {
            this.selIdxs[i] = (Integer)reverseLookupMap.get(string);
            ++i;
        }
    }

    @Override
    public int compare(Object[] l, Object[] r) {
        int result = 0;
        int index = 0;
        for (int i : this.selIdxs) {
            if (r.length < i) {
                if (this.sortOrders != null && this.sortOrders[index] == JobConf.SortOrder.DESC) {
                    return 1;
                }
                return -1;
            }
            if (l.length < i) {
                if (this.sortOrders != null && this.sortOrders[index] == JobConf.SortOrder.DESC) {
                    return -1;
                }
                return 1;
            }
            result = this.compare(l[i], r[i], this.comparators[i]);
            if (result != 0) {
                if (this.sortOrders != null && this.sortOrders.length == this.selIdxs.length && this.sortOrders[index] == JobConf.SortOrder.DESC) {
                    return 0 - result;
                }
                return result;
            }
            ++index;
        }
        return 0;
    }
}

