/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge.streaming.io;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.mapred.bridge.streaming.PipeMapRed;
import com.aliyun.odps.mapred.bridge.streaming.io.LineReader;
import com.aliyun.odps.mapred.bridge.streaming.io.OutputReader;
import com.aliyun.odps.mapred.utils.UTF8ByteArrayUtils;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class RecordOutputReader
extends OutputReader<Object, Text[]> {
    private LineReader lineReader;
    private byte[] bytes;
    private DataInput clientIn;
    private Configuration conf;
    private int numFields;
    private byte[] separator;
    private Text line;
    private Text[] value;

    @Override
    public void initialize(PipeMapRed pipeMapRed) throws IOException {
        super.initialize(pipeMapRed);
        this.clientIn = pipeMapRed.getClientInput();
        this.conf = pipeMapRed.getConfiguration();
        this.numFields = pipeMapRed.getNumOfOutputFields();
        this.separator = pipeMapRed.getFieldSeparator();
        this.lineReader = new LineReader((InputStream)((Object)this.clientIn), this.conf);
        this.line = new Text();
        this.value = new Text[this.numFields];
    }

    @Override
    public boolean readKeyValue() throws IOException {
        if (this.lineReader.readLine(this.line) <= 0) {
            return false;
        }
        this.bytes = this.line.getBytes();
        try {
            this.splitFields(this.bytes, this.line.getLength(), this.value);
        }
        catch (IOException e) {
            System.err.println("Stop on line:'" + this.line + "'");
            throw e;
        }
        this.line.clear();
        return true;
    }

    @Override
    public Object getCurrentKey() throws IOException {
        return null;
    }

    @Override
    public Text[] getCurrentValue() throws IOException {
        return this.value;
    }

    @Override
    public String getLastOutput() {
        if (this.bytes != null) {
            try {
                return new String(this.bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "<undecodable>";
            }
        }
        return null;
    }

    private void splitFields(byte[] line, int length, Text[] fields) throws IOException {
        Text field;
        int k;
        int start = 0;
        int pos = UTF8ByteArrayUtils.findBytes((byte[])line, (int)start, (int)length, (byte[])this.separator);
        for (k = 0; k < this.numFields - 1 && pos != -1; ++k) {
            field = new Text();
            field.set(line, start, pos - start);
            fields[k] = field;
            start = pos + this.separator.length;
            pos = UTF8ByteArrayUtils.findBytes((byte[])line, (int)start, (int)length, (byte[])this.separator);
        }
        if (pos != -1 || k != this.numFields - 1) {
            if (k == this.numFields - 1) {
                throw new IOException("streaming output line has more fields than output schema");
            }
            throw new IOException("streaming output line has less fields than output schema");
        }
        field = new Text();
        field.set(line, start, length - start);
        fields[k] = field;
    }
}

