/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.bridge;

import com.aliyun.odps.FileResource;
import com.aliyun.odps.Function;
import com.aliyun.odps.Instance;
import com.aliyun.odps.JarResource;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Resource;
import com.aliyun.odps.Table;
import com.aliyun.odps.Task;
import com.aliyun.odps.mapred.bridge.MetaExplorer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaExplorerImpl
implements MetaExplorer {
    private static final Log LOG = LogFactory.getLog(MetaExplorer.class);
    private Odps odps;

    public MetaExplorerImpl(Odps odps) {
        this.odps = odps;
    }

    @Override
    public String addFileResourceWithRetry(String filePath, Resource.Type type, String padding, boolean isTempResource) throws OdpsException {
        String baseName = FilenameUtils.getBaseName((String)filePath);
        String extension = FilenameUtils.getExtension((String)filePath);
        String resourceName = baseName + padding;
        File file = new File(filePath);
        FileResource res = null;
        switch (type) {
            case FILE: {
                res = new FileResource();
                break;
            }
            case JAR: {
                res = new JarResource();
                break;
            }
            default: {
                throw new OdpsException("Unsupported resource type:" + type);
            }
        }
        FileInputStream in = null;
        res.setIsTempResource(isTempResource);
        String rname = null;
        for (int trial = 0; trial <= 3; ++trial) {
            try {
                rname = resourceName + "_" + trial;
                if (extension != null && !extension.isEmpty()) {
                    rname = rname + "." + extension;
                }
                res.setName(rname);
                in = new FileInputStream(file);
                this.odps.resources().create(res, (InputStream)in);
                String string = rname;
                return string;
            }
            catch (OdpsException e) {
                LOG.error((Object)("Upload resource " + rname + " failed:" + e.getMessage() + ", retry count=" + trial));
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            catch (FileNotFoundException e) {
                throw new OdpsException("Resource file: " + filePath + " not found.", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new OdpsException((Exception)e);
                    }
                }
            }
        }
        throw new OdpsException("Upload resource failed.");
    }

    @Override
    public String addTempResourceWithRetry(InputStream in, String prefix, Resource.Type type) throws OdpsException {
        FileResource res = null;
        String extension = "";
        switch (type) {
            case FILE: {
                res = new FileResource();
                break;
            }
            case JAR: {
                res = new JarResource();
                extension = "jar";
                break;
            }
            default: {
                throw new OdpsException("Unsupported resource type:" + type);
            }
        }
        String resourceName = null;
        res.setIsTempResource(true);
        for (int trial = 0; trial <= 3; ++trial) {
            try {
                resourceName = prefix + "_" + trial;
                if (extension != null && !extension.isEmpty()) {
                    resourceName = resourceName + "." + extension;
                }
                res.setName(resourceName);
                this.odps.resources().create(res, in);
                return resourceName;
            }
            catch (OdpsException e) {
                LOG.error((Object)("Upload resource " + resourceName + " failed:" + e.getMessage() + ", retry count=" + trial));
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    in.reset();
                    continue;
                }
                catch (IOException e1) {
                    break;
                }
            }
        }
        throw new OdpsException("Upload resource failed.");
    }

    @Override
    public boolean existsVolume(String projectName, String volumeName) throws OdpsException {
        return this.odps.volumes().exists(projectName, volumeName);
    }

    @Override
    public void deleteResource(String name) throws OdpsException {
        this.odps.resources().delete(this.odps.getDefaultProject(), name);
    }

    @Override
    public boolean existsTable(String proj, String name) throws OdpsException {
        if (proj == null || proj.isEmpty()) {
            proj = this.odps.getDefaultProject();
        }
        return this.odps.tables().exists(proj, name);
    }

    @Override
    public boolean existsResource(String proj, String name) throws OdpsException {
        if (proj == null || proj.isEmpty()) {
            proj = this.odps.getDefaultProject();
        }
        return this.odps.resources().exists(proj, name);
    }

    @Override
    public void createFunction(List<String> resources, String project, String name, String className) throws OdpsException {
        Function func = new Function();
        func.setName(name);
        func.setClassType(className);
        func.setResources(resources);
        this.odps.functions().create(func);
    }

    @Override
    public void deleteFunction(String project, String name) throws OdpsException {
        this.odps.functions().delete(project, name);
    }

    @Override
    public Table getTable(String projectName, String tblName) {
        if (projectName == null) {
            projectName = this.odps.getDefaultProject();
        }
        return this.odps.tables().get(projectName, tblName);
    }

    @Override
    public String getDefaultProject() {
        return this.odps.getDefaultProject();
    }

    @Override
    public Instance createInstance(Task task, int priority) throws OdpsException {
        return this.odps.instances().create(task, priority);
    }

    @Override
    public String getProjectProperty(String key) throws OdpsException {
        String mode = this.odps.projects().get(this.odps.getDefaultProject()).getProperty(key);
        if (mode == null) {
            return (String)this.odps.projects().get(this.odps.getDefaultProject()).getAllProperties().get(key);
        }
        return mode;
    }
}

